/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.transport;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.transport.Transport;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@Lifecycle(value=Lifecycle.Type.REQUEST)
public class HttpTransport
implements Transport {
    private static List<String> protocols = new ArrayList<String>();
    private URL url = null;
    private URL target = null;

    @Override
    public void init(URL url) {
        this.url = url;
    }

    @Override
    public boolean exists() {
        try {
            Logger.debug((String)("checking if " + this.url + " exists"));
            if (this.url.toString().startsWith("file")) {
                File file = new File(this.url.toURI());
                return file.exists();
            }
            HttpURLConnection conn = this.getConnection();
            conn.connect();
            return conn.getResponseCode() == 200;
        }
        catch (Exception e) {
            Logger.error((String)("unable to check, if url " + this.url + " exists"), (Throwable)e);
            return false;
        }
    }

    @Override
    public long getSize() {
        try {
            Logger.debug((String)("checking download size of " + this.url));
            if (this.url.toString().startsWith("file")) {
                File file = new File(this.url.toURI());
                return file.length();
            }
            HttpURLConnection conn = this.getConnection();
            conn.connect();
            return conn.getContentLength();
        }
        catch (Exception e) {
            Logger.error((String)("unable to determine download size for url " + this.url), (Throwable)e);
            return -1L;
        }
    }

    @Override
    public void get(OutputStream os, ProgressMonitor monitor) throws Exception {
        I18N i18n = Application.getI18n();
        Logger.info((String)("downloading " + this.url));
        if (os == null) {
            throw new ApplicationException(i18n.tr("Kein Download-Ziel angegeben"));
        }
        HttpURLConnection conn = this.getConnection();
        conn.connect();
        if (monitor != null) {
            monitor.setStatusText(i18n.tr("Download von {0}", this.url.toString()));
        }
        int length = conn.getContentLength();
        long start = System.currentTimeMillis();
        long count = 0L;
        long last = 0L;
        if (length <= 0) {
            length = 0x500000;
        }
        double factor = 100.0 / (double)length;
        InputStream is = null;
        try {
            is = conn.getInputStream();
            byte[] buf = new byte[4096];
            int read = 0;
            while ((read = is.read(buf)) != -1) {
                long now;
                os.write(buf, 0, read);
                count += (long)read;
                if (monitor != null) {
                    monitor.setPercentComplete((int)((double)count * factor));
                }
                if ((now = System.currentTimeMillis()) - last <= 5000L) continue;
                long millis = now - start;
                if (millis > 0L) {
                    long kbps = count / millis;
                    if (monitor != null) {
                        monitor.log(i18n.tr("{0} Kb/sek", "" + kbps));
                    }
                }
                last = now;
            }
            long used = System.currentTimeMillis() - start;
            if (used > 0L) {
                long kbps = used == 0L ? count : count / used;
                Logger.debug((String)("download finished. " + kbps + " Kb/sek"));
            } else {
                Logger.debug((String)"download finished in less than a second");
            }
            if (monitor != null) {
                monitor.setPercentComplete(100);
                monitor.setStatus(4);
                monitor.setStatusText(i18n.tr("Download beendet"));
            }
        }
        catch (Exception e) {
            try {
                if (monitor != null) {
                    monitor.setStatus(3);
                    monitor.log(e.getMessage());
                    monitor.setStatusText(i18n.tr("Fehler beim Download: {0}", e.getMessage()));
                }
                throw e;
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is, os});
                throw throwable;
            }
        }
        IOUtil.close((Closeable[])new Closeable[]{is, os});
    }

    private HttpURLConnection getConnection() throws Exception {
        if (this.target != null) {
            return (HttpURLConnection)this.target.openConnection();
        }
        URL curr = this.url;
        for (int i = 0; i < 10; ++i) {
            String s2;
            HttpURLConnection conn = (HttpURLConnection)curr.openConnection();
            conn.setInstanceFollowRedirects(false);
            int code = conn.getResponseCode();
            if (code != 301 && code != 302) {
                this.target = curr;
                return conn;
            }
            String loc = StringUtils.trimToNull((String)conn.getHeaderField("Location"));
            if (loc == null) {
                Logger.warn((String)("got http status moved (" + code + ") but no location"));
                return conn;
            }
            URL prev = curr;
            loc = URLDecoder.decode(loc, "UTF-8");
            curr = new URL(this.url, loc);
            String s1 = this.url.getHost();
            if (!StringUtils.equalsIgnoreCase((String)s1, (String)(s2 = curr.getHost()))) {
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Umleitung von {0} auf {1} aus Sicherheitsgr\u00fcnden nicht erlaubt", new String[]{s1, s2}), 1));
                throw new SecurityException("got http redirect with change to another host, not permitted for security reasons [source: " + s1 + ", target: " + s2 + "]");
            }
            Logger.info((String)("got redirect from " + prev + " to " + curr));
        }
        throw new IOException("too many redirects for url: " + this.url);
    }

    @Override
    public List<String> getProtocols() {
        return protocols;
    }

    static {
        protocols.add("http");
        protocols.add("https");
        protocols.add("file");
    }
}

