/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.jameica.messaging.BootMessage;
import de.willuhn.jameica.messaging.BootMessageConsumer;
import de.willuhn.jameica.messaging.MessagingQueue;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.ApplicationCallback;
import de.willuhn.jameica.system.ApplicationCallbackConsole;
import de.willuhn.jameica.system.ApplicationController;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.ConsoleMonitor;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.util.List;

public class Server
implements ApplicationController {
    private ApplicationCallback callback = null;

    @Override
    public void init() throws ApplicationException {
        Application.getMessagingFactory().sendMessage(new SystemMessage(1, "jameica up and running..."));
        MessagingQueue queue = Application.getMessagingFactory().getMessagingQueue("jameica.boot");
        queue.flush();
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        List<BootMessage> messages = service.get(BootMessageConsumer.class).getMessages();
        if (messages != null && messages.size() > 0) {
            try {
                Logger.flush();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Logger.info((String)"----------------------------------------------------------------------");
            Logger.info((String)Application.getI18n().tr("Startup-Messages:"));
            for (BootMessage m : messages) {
                Object text = m.getText();
                if (text == null || ((String)text).length() == 0) continue;
                String title = m.getTitle();
                if (title != null && title.length() > 0) {
                    text = title + ": " + (String)text;
                }
                Logger.info((String)("  " + (String)text));
            }
        }
        Logger.info((String)"----------------------------------------------------------------------");
        if (!Application.inNonInteractiveMode()) {
            Logger.info((String)Application.getI18n().tr("press \"<CTRL><C>\" to shut down the server."));
        }
        if (Application.inNonInteractiveMode()) {
            try {
                Logger.flush();
                Logger.info((String)"detatching terminal");
                Logger.flush();
                System.out.close();
                System.in.close();
                System.err.close();
                Logger.info((String)"terminal detached");
            }
            catch (Exception e) {
                Logger.error((String)"unable to detach terminal", (Throwable)e);
            }
        }
    }

    @Override
    public void shutDown() {
        Application.shutDown();
    }

    @Override
    public ApplicationCallback getApplicationCallback() {
        if (this.callback == null) {
            this.callback = new ApplicationCallbackConsole();
        }
        return this.callback;
    }

    @Override
    public void start(final BackgroundTask task) {
        Thread t = new Thread("[Jameica Backgroundtask] " + task.getClass().getName()){

            @Override
            public void run() {
                ConsoleMonitor monitor = new ConsoleMonitor();
                try {
                    task.run(monitor);
                }
                catch (OperationCanceledException oce) {
                    if (monitor != null) {
                        monitor.setStatus(5);
                    }
                }
                catch (Throwable t) {
                    Logger.error((String)"error while executing background task", (Throwable)t);
                    if (monitor != null) {
                        monitor.setStatus(3);
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.setStatus(4);
                    }
                }
            }
        };
        t.start();
    }
}

