/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.MultipleClassLoader;
import java.net.URL;

public class MigratingMultipleClassLoader
extends MultipleClassLoader {
    public void add(URL url) {
        String key = this.getMigrationKey(url);
        if (key != null) {
            boolean enabled = Application.getConfig().getMigration(key);
            Logger.info((String)("migration " + key + ": " + enabled));
            if (!url.toString().contains(key + "/" + (enabled ? "enabled" : "disabled"))) {
                Logger.info((String)("excluding " + url));
                return;
            }
            Logger.info((String)("including " + url));
        }
        super.add(url);
    }

    private String getMigrationKey(URL url) {
        String[] parts = url.getPath().split("/");
        if (parts == null || parts.length < 1) {
            return null;
        }
        for (String s : parts) {
            if (!s.startsWith("migration-")) continue;
            return s;
        }
        return null;
    }
}

