/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.jameica.messaging.CheckTrustMessage;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.security.Certificate;
import de.willuhn.jameica.security.JameicaAuthenticator;
import de.willuhn.jameica.security.Login;
import de.willuhn.jameica.security.LoginVerifier;
import de.willuhn.jameica.security.Principal;
import de.willuhn.jameica.system.AbstractApplicationCallback;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;

public class ApplicationCallbackConsole
extends AbstractApplicationCallback {
    private ProgressMonitor startup = null;
    private ProgressMonitor shutdown = null;
    private String username = null;
    private String password = null;

    @Override
    public boolean lockExists(String lockfile) {
        I18N i18n = Application.getI18n();
        if (Application.inNonInteractiveMode()) {
            Logger.error((String)i18n.tr("Der Jameica-Server scheint bereits zu laufen, da das Lockfile {0} existiert.", lockfile));
            Logger.error((String)i18n.tr("Bitte l\u00f6schen Sie ggf. die Datei und versuchen es erneut."));
            return false;
        }
        this.flush();
        System.out.println("----------------------------------------------------------------------");
        System.out.println(i18n.tr("Der Jameica-Server scheint bereits zu laufen, da das Lockfile {0} existiert.", lockfile));
        System.out.println(i18n.tr("Geben Sie <J> ein, um den Startvorgang fortzusetzen oder <N> zum Beenden."));
        System.out.println("----------------------------------------------------------------------");
        System.out.print(i18n.tr("Ihre Eingabe [J/N]: "));
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader keyboard = new BufferedReader(isr);
        try {
            String input = keyboard.readLine();
            if ("j".equalsIgnoreCase(input) || "y".equalsIgnoreCase(input)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String createPassword() throws Exception {
        I18N i18n = Application.getI18n();
        this.username = Application.getStartupParams().getUsername();
        String s = Customizing.SETTINGS.getString("application.firststart.username", null);
        if (StringUtils.trimToNull((String)this.username) == null && StringUtils.trimToNull((String)s) != null) {
            if (Application.inNonInteractiveMode()) {
                Logger.error((String)i18n.tr("Jameica l\u00e4uft im nicht-interaktiven Modus und kein Benutzername via Kommandozeile \u00fcbergeben"));
                throw new ApplicationException(i18n.tr("Username kann nicht abgefragt werden"));
            }
            this.flush();
            System.out.print(s);
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader keyboard = new BufferedReader(isr);
            this.username = keyboard.readLine();
        }
        this.password = Application.getStartupParams().getPassword();
        if (this.password != null && this.password.length() > 0) {
            Logger.debug((String)"master password given via commandline");
            return this.password;
        }
        this.password = Application.getStartupParams().getPasswordUsingCommand();
        if (this.password != null && this.password.length() > 0) {
            Logger.debug((String)"master password given via command specified in commandline");
            return this.password;
        }
        if (Application.inNonInteractiveMode()) {
            Logger.error((String)i18n.tr("Jameica l\u00e4uft im nicht-interaktiven Modus und kein Passwort via Kommandozeile \u00fcbergeben"));
            throw new ApplicationException(i18n.tr("Passwort kann nicht abgefragt werden"));
        }
        this.flush();
        System.out.println("");
        System.out.println(i18n.tr("Sie starten Jameica zum ersten Mal.\nBitte vergeben Sie ein Master-Passwort zum Schutz Ihrer pers\u00f6nlichen Daten:"));
        this.password = this.promptPassword();
        return this.password;
    }

    private String promptPassword() throws Exception {
        String label = Application.getI18n().tr("Passwort") + ": ";
        Console console = System.console();
        for (int i = 0; i < 10; ++i) {
            String s = null;
            if (console != null) {
                s = new String(console.readPassword(label, new Object[0]));
            } else {
                System.out.print(label);
                InputStreamReader isr = new InputStreamReader(System.in);
                BufferedReader keyboard = new BufferedReader(isr);
                s = keyboard.readLine();
            }
            if (s == null || s.length() <= 0) continue;
            return s;
        }
        Logger.error((String)"no password, giving up");
        throw new ApplicationException(Application.getI18n().tr("Kein Passwort eingegeben"));
    }

    @Override
    public String getPassword() throws Exception {
        return this.getPassword(null);
    }

    @Override
    public String getPassword(LoginVerifier verifier) throws Exception {
        I18N i18n = Application.getI18n();
        if (this.username == null) {
            this.username = Application.getStartupParams().getUsername();
        }
        if (this.password != null) {
            return this.password;
        }
        String s = Customizing.SETTINGS.getString("application.start.username", null);
        if (StringUtils.trimToNull((String)this.username) == null && StringUtils.trimToNull((String)s) != null) {
            if (Application.inNonInteractiveMode()) {
                Logger.error((String)i18n.tr("Jameica l\u00e4uft im nicht-interaktiven Modus und kein Benutzername via Kommandozeile \u00fcbergeben"));
                throw new ApplicationException(i18n.tr("Username kann nicht abgefragt werden"));
            }
            this.flush();
            System.out.print(s);
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader keyboard = new BufferedReader(isr);
            this.username = keyboard.readLine();
        }
        this.password = Application.getStartupParams().getPassword();
        if (this.password == null || this.password.length() == 0) {
            this.password = Application.getStartupParams().getPasswordUsingCommand();
        }
        if (this.password != null && this.password.length() > 0) {
            Logger.info((String)"master password given via commandline");
            if (verifier == null) {
                return this.password;
            }
            if (verifier.verify(this.username, this.password.toCharArray())) {
                return this.password;
            }
            Logger.info((String)"commandline password wrong");
        }
        if (Application.inNonInteractiveMode()) {
            Logger.error((String)i18n.tr("Jameica l\u00e4uft im nicht-interaktiven Modus und kein Passwort via Kommandozeile \u00fcbergeben"));
            throw new ApplicationException(i18n.tr("Passwort kann nicht abgefragt werden"));
        }
        this.flush();
        System.out.println("");
        System.out.println(i18n.tr("Bitte geben Sie das Jameica Master-Passwort ein:"));
        for (int i = 0; i < 3; ++i) {
            this.password = this.promptPassword();
            if (this.password != null && this.password.length() > 0) {
                if (verifier == null) {
                    return this.password;
                }
                if (verifier.verify(this.username, this.password.toCharArray())) {
                    return this.password;
                }
            }
            System.out.println(i18n.tr("Passwort falsch. Bitte versuchen Sie es erneut:"));
        }
        throw new Exception("Wrong jameica keystore password");
    }

    @Override
    public void changePassword() throws Exception {
        if (Application.inNonInteractiveMode()) {
            Logger.error((String)Application.getI18n().tr("Jameica l\u00e4uft im nicht-interaktiven Modus und kein Passwort via Kommandozeile \u00fcbergeben"));
            throw new ApplicationException(Application.getI18n().tr("Passwort kann nicht abgefragt werden"));
        }
        this.flush();
        System.out.print(Application.getI18n().tr("Bitte geben Sie Ihr neues Master-Passwort zum Schutz Ihrer pers\u00f6nlichen Daten ein.\nEs wird anschlie\u00dfend bei jedem Start von Jameica ben\u00f6tigt:"));
        this.password = this.promptPassword();
    }

    @Override
    public ProgressMonitor getStartupMonitor() {
        if (this.startup != null) {
            return this.startup;
        }
        this.startup = new ProgressMonitor(){
            private int complete = 0;

            public void setPercentComplete(int percent) {
                this.complete = percent;
                if (this.complete > 100) {
                    this.complete = 100;
                }
                Logger.debug((String)("completed: " + this.complete + " %"));
            }

            public void addPercentComplete(int percent) {
                if (percent < 1) {
                    return;
                }
                this.setPercentComplete(this.getPercentComplete() + percent);
            }

            public int getPercentComplete() {
                return this.complete;
            }

            public void setStatus(int status) {
            }

            public void setStatusText(String text) {
                Logger.debug((String)text);
            }

            public void log(String msg) {
                Logger.debug((String)msg);
            }
        };
        return this.startup;
    }

    @Override
    public ProgressMonitor getShutdownMonitor() {
        if (this.shutdown != null) {
            return this.shutdown;
        }
        this.shutdown = new ProgressMonitor(){
            private int complete = 0;

            public void setPercentComplete(int percent) {
                this.complete = percent;
                Logger.debug((String)("completed: " + this.complete + " %"));
            }

            public void addPercentComplete(int percent) {
                if (percent < 1) {
                    return;
                }
                this.setPercentComplete(this.getPercentComplete() + percent);
            }

            public int getPercentComplete() {
                return this.complete;
            }

            public void setStatus(int status) {
            }

            public void setStatusText(String text) {
                Logger.info((String)text);
            }

            public void log(String msg) {
                Logger.debug((String)msg);
            }
        };
        return this.shutdown;
    }

    @Override
    public void startupError(String errorMessage, Throwable t) {
        System.out.println(errorMessage);
        t.printStackTrace();
    }

    @Override
    public String askUser(String question, String labeltext) throws Exception {
        QueryMessage msg = new QueryMessage(question, null);
        Application.getMessagingFactory().getMessagingQueue("jameica.callback.ask.question").sendSyncMessage(msg);
        Object data = msg.getData();
        if (data != null) {
            Logger.debug((String)("question " + question + " answered via messaging"));
            return data.toString();
        }
        if (Application.inNonInteractiveMode()) {
            Logger.error((String)Application.getI18n().tr("Jameica l\u00e4uft im nicht-interaktiven Modus. Beantwortung der Frage \"{0}\" nicht m\u00f6glich", question));
            throw new ApplicationException(Application.getI18n().tr("Benutzer-Interaktion nicht m\u00f6glich. Jameica l\u00e4uft im nicht-interaktiven Modus"));
        }
        this.flush();
        if (labeltext != null && labeltext.length() > 0) {
            System.out.println(question);
            System.out.print(labeltext + ": ");
        } else {
            System.out.print(question);
        }
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader keyboard = new BufferedReader(isr);
        return keyboard.readLine();
    }

    @Override
    public String askPassword(String question) throws Exception {
        return this.askUser(question, Application.getI18n().tr("Passwort"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTrust(X509Certificate cert) throws Exception {
        CheckTrustMessage msg = new CheckTrustMessage(cert);
        Application.getMessagingFactory().sendSyncMessage(msg);
        Exception ex = msg.getException();
        if (ex != null) {
            throw ex;
        }
        Boolean trust = msg.isTrusted();
        if (trust != null) {
            Logger.info((String)("cert: " + cert.getSubjectDN().getName() + "," + (trust != false ? "" : " NOT ") + " trusted by: " + msg.getTrustedBy()));
            return trust;
        }
        if (Application.inNonInteractiveMode()) {
            boolean b;
            File f = new File(Application.getConfig().getWorkDir(), "untrusted");
            Logger.error((String)Application.getI18n().tr("Jameica l\u00e4uft im nicht-interaktiven Modus. Vertrauensstellung des Zertifikats kann nicht abgefragt werden"));
            Logger.warn((String)Application.getI18n().tr("Speichere Zertifikat im Verzeichnis {0}", f.getAbsolutePath()));
            if (!(!f.exists() || f.isDirectory() && f.canWrite())) {
                throw new ApplicationException(Application.getI18n().tr("Kann in Incoming-Verzeichnis {0} nicht schreiben", f.getAbsolutePath()));
            }
            if (!f.exists() && !(b = f.mkdirs())) {
                throw new ApplicationException(Application.getI18n().tr("Incoming-Verzeichnis {0} konnte nicht erstellt werden", f.getAbsolutePath()));
            }
            OutputStream os = null;
            try {
                Certificate myCert = new Certificate(cert);
                Principal p = myCert.getSubject();
                Object name = p.getAttribute("CN") + "__" + cert.getSerialNumber().toString();
                name = ((String)name).replaceAll("[^A-Za-z0-9\\-_]", "_");
                if (((String)name).length() > 50) {
                    name = ((String)name).substring(0, 49);
                }
                name = (String)name + ".crt";
                File target = new File(f, (String)name);
                Logger.info((String)Application.getI18n().tr("Speichere Zertifikat in {0}", target.getAbsolutePath()));
                if (target.exists()) {
                    Logger.warn((String)Application.getI18n().tr("Zertifikat {0} existiert bereits", target.getAbsolutePath()));
                    boolean bl = false;
                    return bl;
                }
                os = new BufferedOutputStream(new FileOutputStream(target));
                os.write(cert.getEncoded());
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return false;
        }
        DateFormat df = DateFormat.getDateInstance(2, Application.getConfig().getLocale());
        Certificate myCert = new Certificate(cert);
        I18N i18n = Application.getI18n();
        this.flush();
        System.out.println("----------------------------------------------------------------------");
        System.out.println(i18n.tr("Eigenschaften des Zertifikats"));
        System.out.println(i18n.tr("Ausgestellt von:      ") + cert.getIssuerDN().getName());
        System.out.println(i18n.tr("Ausgestellt f\u00fcr:      ") + cert.getSubjectDN().getName());
        System.out.println(i18n.tr("G\u00fcltig von:           ") + df.format(cert.getNotBefore()));
        System.out.println(i18n.tr("G\u00fcltig bis:           ") + df.format(cert.getNotAfter()));
        System.out.println(i18n.tr("Seriennummer:         ") + "0x" + cert.getSerialNumber().toString(16).toUpperCase());
        System.out.println(i18n.tr("Typ:                  ") + cert.getType());
        System.out.println(i18n.tr("SHA1-Fingerabdruck:   ") + myCert.getSHA1Fingerprint());
        System.out.println(i18n.tr("SHA256-Fingerabdruck: ") + myCert.getSHA256Fingerprint());
        System.out.println("----------------------------------------------------------------------");
        System.out.println(i18n.tr("Das Zertifikat des Systems konnte nicht verifiziert werden. M\u00f6chten Sie diesem Zertifikat vertrauen? [J/N]"));
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader keyboard = new BufferedReader(isr);
        String s = keyboard.readLine();
        return s != null && ("j".equalsIgnoreCase(s) || "y".equalsIgnoreCase(s));
    }

    @Override
    public void notifyUser(String text) throws Exception {
        if (Application.inNonInteractiveMode()) {
            Logger.info((String)text);
            return;
        }
        this.flush();
        System.out.println("----------------------------------------------------------------------");
        System.out.println(text);
        System.out.println("----------------------------------------------------------------------");
    }

    @Override
    public boolean askUser(String question) throws Exception {
        return this.askUser(question, (String[])null);
    }

    @Override
    public boolean askUser(String question, String[] variables) throws Exception {
        return this.askUser(question, variables, true);
    }

    @Override
    public boolean askUser(String question, boolean storeAnswer) throws Exception {
        return this.askUser(question, null, storeAnswer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean askUser(String question, String[] variables, boolean storeAnswer) throws Exception {
        String text;
        String s;
        if (question == null) {
            Logger.warn((String)"<null> question!");
            return false;
        }
        if (storeAnswer && (s = this.settings.getString(question, null)) != null) {
            return s.equalsIgnoreCase("true");
        }
        QueryMessage msg = new QueryMessage(question, null);
        Application.getMessagingFactory().getMessagingQueue("jameica.callback.ask.question").sendSyncMessage(msg);
        Object data = msg.getData();
        if (data instanceof Boolean) {
            Logger.debug((String)("question " + question + " answered via messaging as: " + data));
            return (Boolean)data;
        }
        String string = text = variables == null || variables.length == 0 ? question : MessageFormat.format(question, variables);
        if (Application.inNonInteractiveMode()) {
            Logger.warn((String)text);
            Logger.warn((String)"Jameica laeuft im Nicht-Interaktiven Modus. Frage kann daher nicht beantwortet werden");
            throw new ApplicationException(Application.getI18n().tr("Benutzer-Interaktion nicht m\u00f6glich. Jameica l\u00e4uft im nicht-interaktiven Modus"));
        }
        this.notifyUser(text + "\n[Y/N]");
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader keyboard = new BufferedReader(isr);
        boolean answer = false;
        try {
            String input = keyboard.readLine();
            if ("y".equalsIgnoreCase(input)) {
                answer = true;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (storeAnswer) {
                this.settings.setAttribute(question, answer);
            }
        }
        return answer;
    }

    private void flush() {
        try {
            Logger.flush();
            System.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Login login(JameicaAuthenticator auth) throws Exception {
        Login l = super.login(auth);
        if (l != null) {
            return l;
        }
        if (Application.inNonInteractiveMode()) {
            Logger.warn((String)"Jameica laeuft im Nicht-Interaktiven Modus. Eingabe von Benutzername und Passwort nicht m\u00f6glich");
            throw new ApplicationException(Application.getI18n().tr("Benutzer-Interaktion nicht m\u00f6glich. Jameica l\u00e4uft im nicht-interaktiven Modus"));
        }
        Object notify = Application.getI18n().tr("Bitten geben Sie Benutzername und Passwort ein");
        String prompt = (String)auth.getRequestParam(JameicaAuthenticator.RequestParam.PROMPT);
        String host = (String)auth.getRequestParam(JameicaAuthenticator.RequestParam.HOST);
        if (host != null && host.length() > 0) {
            notify = (String)notify + "\n" + Application.getI18n().tr("Host: {0}", host);
        }
        if (prompt != null && prompt.length() > 0) {
            notify = (String)notify + "\n" + Application.getI18n().tr("Seite: {0}", prompt);
        }
        this.notifyUser((String)notify);
        String username = this.askUser(Application.getI18n().tr("Benutzername: "), (String)null);
        String password = this.askUser(Application.getI18n().tr("Passwort: "), (String)null);
        return new Login(username, password == null ? null : password.toCharArray());
    }
}

