/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.boot.BootLoader;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.messaging.BootMessage;
import de.willuhn.jameica.messaging.BootMessageConsumer;
import de.willuhn.jameica.messaging.MessagingFactory;
import de.willuhn.jameica.messaging.MessagingQueue;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.PluginLoader;
import de.willuhn.jameica.security.SSLFactory;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.Init5;
import de.willuhn.jameica.services.MessagingService;
import de.willuhn.jameica.services.PluginService;
import de.willuhn.jameica.services.PluginServiceService;
import de.willuhn.jameica.services.SSLService;
import de.willuhn.jameica.system.ApplicationCallback;
import de.willuhn.jameica.system.ApplicationController;
import de.willuhn.jameica.system.Config;
import de.willuhn.jameica.system.MigratingMultipleClassLoader;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Platform;
import de.willuhn.jameica.system.Server;
import de.willuhn.jameica.system.ServiceFactory;
import de.willuhn.jameica.system.StartupParams;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.JarInfo;
import de.willuhn.util.MultipleClassLoader;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.jar.JarFile;

public final class Application {
    private static Application app = null;
    private boolean inShutdown = false;
    private boolean hookRunning = false;
    private StartupParams params;
    private Manifest manifest;
    private Platform platform;
    private Config config;
    private MultipleClassLoader classLoader;
    private BootLoader loader;
    private I18N i18n;
    private Date started = new Date();
    private ApplicationController controller;

    public static void newInstance(StartupParams params) {
        MigratingMultipleClassLoader cl = new MigratingMultipleClassLoader();
        cl.setName("loader.jameica");
        cl.addClassloader(Application.class.getClassLoader());
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)cl));
        app = new Application();
        Application.app.params = params;
        Application.app.classLoader = cl;
        app.init();
    }

    private void init() {
        Logger.info((String)"starting jameica...");
        Application.getCallback().getStartupMonitor().setStatusText("starting jameica");
        try {
            Application.app.loader = new BootLoader();
            Application.app.loader.setMonitor(Application.getCallback().getStartupMonitor());
            Application.app.loader.getBootable(Init5.class);
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                Logger.warn((String)"startup cancelled by user");
            }
            app.startupError(e);
        }
        Application.getCallback().getStartupMonitor().setPercentComplete(100);
        Application.getCallback().getStartupMonitor().setStatus(0);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (Application.app.hookRunning || Application.app.inShutdown) {
                    return;
                }
                Application.app.hookRunning = true;
                Logger.info((String)"shutting down via shutdown hook");
                Application.getController().shutDown();
            }
        });
        try {
            Application.getController().init();
        }
        catch (ApplicationException e1) {
            Logger.error((String)"unable to init application controller", (Throwable)e1);
        }
    }

    private void startupError(Throwable t) {
        if (t != null && !(t instanceof OperationCanceledException)) {
            String msg;
            t.printStackTrace();
            Logger.error((String)"FATAL ERROR WHILE JAMEICA STARTUP", (Throwable)t);
            StringBuffer sb = new StringBuffer();
            Throwable cause = t;
            for (int i = 0; i < 20; ++i) {
                sb.append(cause.getMessage());
                sb.append("\n");
                Throwable next = cause.getCause();
                if (next == null || next == cause) break;
                cause = next;
            }
            if ((msg = sb.toString()) == null || msg.length() == 0) {
                msg = "Fatal error while jameica startup";
            }
            Application.getCallback().startupError(msg, t);
        }
        try {
            Logger.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(1);
    }

    public static void shutDown() {
        if (Application.app.inShutdown) {
            return;
        }
        Application.app.inShutdown = true;
        try {
            Application.getMessagingFactory().sendSyncMessage(new SystemMessage(2, "shutting down jameica"));
            Application.app.loader.setMonitor(Application.getCallback().getShutdownMonitor());
            Application.getController().shutDown();
            Application.app.loader.shutdown();
            Application.getCallback().getStartupMonitor().setStatus(0);
            Logger.info((String)"shutdown complete");
            Logger.info((String)"--------------------------------------------------\n");
            Logger.close();
        }
        finally {
            if (!Application.app.hookRunning) {
                System.exit(0);
            }
        }
    }

    public static MultipleClassLoader getClassLoader() {
        return Application.app.classLoader;
    }

    public static BootLoader getBootLoader() {
        return Application.app.loader;
    }

    public static SSLFactory getSSLFactory() {
        SSLService sss = (SSLService)Application.getBootLoader().getBootable(SSLService.class);
        return sss.getSSLFactory();
    }

    public static ServiceFactory getServiceFactory() {
        PluginServiceService pss = (PluginServiceService)Application.getBootLoader().getBootable(PluginServiceService.class);
        return pss.getServiceFactory();
    }

    public static PluginLoader getPluginLoader() {
        PluginService ps = (PluginService)Application.getBootLoader().getBootable(PluginService.class);
        return ps.getPluginLoader();
    }

    public static MessagingFactory getMessagingFactory() {
        MessagingService ms = (MessagingService)Application.getBootLoader().getBootable(MessagingService.class);
        return ms.getMessagingFactory();
    }

    public static Config getConfig() {
        if (Application.app.config != null) {
            return Application.app.config;
        }
        try {
            Application.app.config = new Config();
            Application.app.config.init();
        }
        catch (Throwable t) {
            app.startupError(t);
        }
        return Application.app.config;
    }

    public static Platform getPlatform() {
        if (Application.app.platform != null) {
            return Application.app.platform;
        }
        Application.app.platform = Platform.getInstance();
        return Application.app.platform;
    }

    public static boolean inServerMode() {
        return Application.app.params.getMode() == 1;
    }

    public static boolean inStandaloneMode() {
        return Application.app.params.getMode() == 0;
    }

    public static boolean inClientMode() {
        return Application.app.params.getMode() == 2;
    }

    public static boolean inNonInteractiveMode() {
        return Application.app.params.isNonInteractiveMode();
    }

    public static I18N getI18n() {
        if (Application.app.i18n != null) {
            return Application.app.i18n;
        }
        try {
            Application.app.i18n = new I18N("lang/system_messages", Application.getConfig().getLocale(), (ClassLoader)Application.getClassLoader());
        }
        catch (Exception e) {
            Logger.error((String)"unable to load system resource bundle, fallback to dummy", (Throwable)e);
            Application.app.i18n = new I18N();
        }
        return Application.app.i18n;
    }

    public static StartupParams getStartupParams() {
        return Application.app.params;
    }

    public static Date getStartDate() {
        return Application.app.started;
    }

    public static ApplicationController getController() {
        if (Application.app.controller == null) {
            Application.app.controller = Application.inServerMode() ? new Server() : new GUI();
        }
        return Application.app.controller;
    }

    public static ApplicationCallback getCallback() {
        return Application.getController().getApplicationCallback();
    }

    @Deprecated
    public static void addWelcomeMessage(String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage(new BootMessage(message));
    }

    @Deprecated
    public static String[] getWelcomeMessages() {
        MessagingQueue queue = Application.getMessagingFactory().getMessagingQueue("jameica.boot");
        queue.flush();
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        BootMessageConsumer consumer = service.get(BootMessageConsumer.class);
        LinkedList<String> list = new LinkedList<String>();
        for (BootMessage msg : consumer.getMessages()) {
            list.add(msg.getText());
        }
        return list.toArray(new String[list.size()]);
    }

    public static Manifest getManifest() {
        if (Application.app.manifest == null) {
            try {
                Application.app.manifest = new Manifest(new File("plugin.xml"));
            }
            catch (Exception e) {
                app.startupError(e);
            }
        }
        return Application.app.manifest;
    }

    public static int getBuildnumber() {
        try {
            return new JarInfo(new JarFile("jameica.jar")).getBuildnumber();
        }
        catch (Throwable t) {
            Logger.warn((String)"unable to determine build number. Running in debugger?");
            return 1;
        }
    }

    public static String getBuildDate() {
        try {
            return new JarInfo(new JarFile("jameica.jar")).getBuildDate();
        }
        catch (Throwable t) {
            Logger.warn((String)"unable to determine build date. Running in debugger?");
            return "";
        }
    }
}

