/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.store;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.security.crypto.AESEngine;
import de.willuhn.jameica.security.crypto.Engine;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.store.BeanContainer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

@Lifecycle(value=Lifecycle.Type.REQUEST)
public class BeanStore {
    private Engine engine = new AESEngine();

    public <T> BeanContainer<T> load(Class<T> type, boolean encrypted) throws ApplicationException {
        BeanContainer beanContainer;
        File file = this.getFile(type, encrypted);
        if (!file.exists()) {
            BeanContainer<T> container = new BeanContainer<T>(type, encrypted);
            Logger.info((String)("created new " + container));
            return container;
        }
        BufferedInputStream is = null;
        InputStream is2 = null;
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{BeanContainer.class, type});
            Unmarshaller u = ctx.createUnmarshaller();
            final BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            u.setListener(new Unmarshaller.Listener(){

                public void afterUnmarshal(Object target, Object parent) {
                    beanService.inject(target);
                }
            });
            is = new BufferedInputStream(new FileInputStream(file));
            Logger.info((String)("loading bean container from " + file));
            if (encrypted) {
                Logger.info((String)"decrypting bean container");
                is2 = this.engine.decrypt(is);
            }
            BeanContainer container = (BeanContainer)u.unmarshal(is2);
            Logger.info((String)("loaded " + container));
            beanContainer = container;
        }
        catch (Exception e) {
            try {
                Logger.error((String)"unable to load bean-container", (Throwable)e);
                throw new ApplicationException(Application.getI18n().tr("Laden des Bean-Container fehlgeschlagen: {0}", e.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is, is2});
                throw throwable;
            }
        }
        IOUtil.close((Closeable[])new Closeable[]{is, is2});
        return beanContainer;
    }

    public void store(BeanContainer container) throws ApplicationException {
        File tmp = null;
        try {
            File file = this.getFile(container.type, container.encrypted);
            tmp = File.createTempFile(file.getName() + "_", "", file.getAbsoluteFile().getParentFile());
            Logger.info((String)("storing " + container + " to " + file));
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{BeanContainer.class, container.type});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            m.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            OutputStream os = new BufferedOutputStream(new FileOutputStream(tmp));
            if (container.encrypted) {
                os = this.engine.encrypt(os);
            }
            m.marshal((Object)container, os);
            os.flush();
            os.close();
            if (!tmp.exists()) {
                throw new IOException("stored file does not exist");
            }
            if (file.exists() && !file.delete()) {
                throw new IOException("deleting of previous file failed");
            }
            tmp.renameTo(file);
            tmp.delete();
            Logger.info((String)("stored " + container));
        }
        catch (Exception e) {
            Logger.error((String)"unable to load bean-container", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Speichern des Bean-Container fehlgeschlagen: {0}", e.getMessage()));
        }
        finally {
            if (tmp != null && tmp.exists()) {
                tmp.delete();
            }
        }
    }

    private File getFile(Class type, boolean encrypted) {
        String dir = Application.getConfig().getConfigDir();
        String name = type.getName();
        return new File(dir, name + "." + (encrypted ? "e" : "") + "beans");
    }
}

