/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services.inject;

import de.willuhn.annotation.Inject;
import de.willuhn.annotation.Injector;
import de.willuhn.boot.Bootable;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.inject.InjectHandler;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;

public class InjectHandlerResource
implements InjectHandler {
    @Override
    public void inject(Object o) throws Exception {
        final String name = o.getClass().getSimpleName();
        Inject.inject((Object)o, (Injector)new Injector(){

            public void inject(Object bean, AccessibleObject field, Annotation annotation) throws Exception {
                Resource r = (Resource)annotation;
                String rname = r.name();
                Class<?> c = r.type();
                Object dep = null;
                if (c == Object.class) {
                    c = null;
                }
                if (c == null) {
                    Class<?>[] params;
                    if (field instanceof Field) {
                        c = ((Field)field).getType();
                    } else if (field instanceof Method && (params = ((Method)field).getParameterTypes()) != null && params.length == 1) {
                        c = params[0];
                    }
                }
                if (rname != null && rname.length() > 0) {
                    Logger.trace((String)("  inject service " + rname + " into " + name));
                    Plugin plugin = Application.getPluginLoader().findByClass(c != null ? c : bean.getClass());
                    if (plugin != null) {
                        dep = Application.getServiceFactory().lookup(plugin.getClass(), rname);
                    } else {
                        Logger.trace((String)("  no plugin found for service " + rname));
                    }
                }
                if (dep == null && c != null) {
                    if (InjectHandlerResource.isBootable(c)) {
                        Logger.trace((String)("  inject bootable " + c.getSimpleName() + " into " + name));
                        dep = Application.getBootLoader().getBootable(c);
                    } else {
                        Logger.trace((String)("  inject bean " + c.getSimpleName() + " into " + name));
                        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                        dep = service.get(c);
                    }
                }
                if (dep == null) {
                    Logger.trace((String)("  resource [name: " + rname + ", type: " + c + "] not found"));
                    return;
                }
                field.setAccessible(true);
                if (field instanceof Method) {
                    ((Method)field).invoke(bean, dep);
                } else if (field instanceof Field) {
                    ((Field)field).set(bean, dep);
                }
            }
        }, (Class[])new Class[]{Resource.class});
    }

    private static boolean isBootable(Class type) {
        Class<?>[] interfaces = type.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return false;
        }
        for (Class<?> c : interfaces) {
            if (!c.equals(Bootable.class)) continue;
            return true;
        }
        return false;
    }
}

