/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services.inject;

import de.willuhn.annotation.Inject;
import de.willuhn.annotation.Injector;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingFactory;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.Receive;
import de.willuhn.jameica.services.inject.InjectHandler;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;

public class InjectHandlerReceive
implements InjectHandler {
    @Override
    public void inject(Object o) throws Exception {
        final String name = o.getClass().getSimpleName();
        Inject.inject((Object)o, (Injector)new Injector(){

            public void inject(final Object bean, AccessibleObject field, Annotation annotation) throws Exception {
                final Method m = (Method)field;
                Receive r = (Receive)annotation;
                String s = StringUtils.trimToNull((String)r.queue());
                Logger.trace((String)("  applying message receiver for queue " + (s != null ? s : "[default]") + " to " + name + "." + m.getName()));
                final MessagingFactory queue = s != null ? Application.getMessagingFactory().getMessagingQueue(s) : Application.getMessagingFactory();
                MessageConsumer consumer = new MessageConsumer(){
                    private WeakReference ref;
                    {
                        this.ref = new WeakReference<Object>(bean);
                    }

                    @Override
                    public void handleMessage(Message message) throws Exception {
                        Object o = this.ref.get();
                        if (o == null) {
                            queue.unRegisterMessageConsumer(this);
                            return;
                        }
                        QueryMessage msg = (QueryMessage)message;
                        if (!m.isAccessible()) {
                            m.setAccessible(true);
                        }
                        m.invoke(o, msg.getData());
                    }

                    @Override
                    public Class[] getExpectedMessageTypes() {
                        return new Class[]{QueryMessage.class};
                    }

                    @Override
                    public boolean autoRegister() {
                        return false;
                    }
                };
                queue.registerMessageConsumer(consumer);
            }
        }, (Class[])new Class[]{Receive.class});
    }
}

