/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.messaging.TextMessage;
import de.willuhn.jameica.plugin.Dependency;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.Version;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.update.PluginData;
import de.willuhn.jameica.update.Repository;
import de.willuhn.jameica.update.ResolverResult;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class UpdateService
implements Bootable {
    private static final Settings settings = new Settings(UpdateService.class);
    private Timer timer = null;
    private Worker worker = null;

    public Class<Bootable>[] depends() {
        return new Class[]{RepositoryService.class};
    }

    public void init(BootLoader arg0, Bootable arg1) throws SkipServiceException {
        if (!this.getUpdateCheck()) {
            Logger.info((String)"update check disabled");
            return;
        }
        Logger.info((String)("update check interval: " + this.getUpdateInterval() + " days"));
        this.timer = new Timer(this.getClass().getSimpleName(), true);
        this.worker = new Worker();
        Logger.info((String)"starting updater thread");
        this.timer.schedule((TimerTask)this.worker, 10000L, 86400000L);
    }

    public void shutdown() {
        if (this.worker != null) {
            try {
                Logger.info((String)"stopping updater thread");
                this.worker.cancel();
            }
            catch (Exception e) {
                Logger.error((String)"error while stopping updater thread", (Throwable)e);
            }
            finally {
                this.worker = null;
            }
        }
        if (this.timer != null) {
            try {
                Logger.info((String)"stopping timer task");
                this.timer.cancel();
            }
            catch (Exception e) {
                Logger.error((String)"error while stopping timer task", (Throwable)e);
            }
            finally {
                this.timer = null;
            }
        }
    }

    public int getUpdateInterval() {
        return settings.getInt("update.check.days", 7);
    }

    public void setUpdateInterval(int days) {
        if (days <= 0) {
            Logger.warn((String)"invalid update interval");
            return;
        }
        settings.setAttribute("update.check.days", days);
    }

    public boolean getUpdateCheck() {
        return settings.getBoolean("update.check", false);
    }

    public void setUpdateCheck(boolean b) {
        settings.setAttribute("update.check", b);
        try {
            if (b && this.worker == null) {
                this.init(null, null);
            } else if (!b && this.worker != null) {
                this.shutdown();
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to start/stop update service", (Throwable)e);
        }
    }

    public boolean getUpdateInstall() {
        return settings.getBoolean("update.install", false);
    }

    public void setUpdateInstall(boolean b) {
        settings.setAttribute("update.install", b);
    }

    public TreeMap<String, List<PluginData>> findUpdates(ProgressMonitor monitor) throws ApplicationException {
        TreeMap<String, List<UpdateStatus>> states = this.findUpdateStates(monitor);
        if (states == null) {
            return null;
        }
        TreeMap<String, List<PluginData>> result = new TreeMap<String, List<PluginData>>();
        for (Map.Entry<String, List<UpdateStatus>> e : states.entrySet()) {
            ArrayList<PluginData> data = new ArrayList<PluginData>();
            for (UpdateStatus s : e.getValue()) {
                data.add(s.plugin);
            }
            result.put(e.getKey(), data);
        }
        return result;
    }

    private TreeMap<String, List<UpdateStatus>> findUpdateStates(ProgressMonitor monitor) throws ApplicationException {
        I18N i18n = Application.getI18n();
        Logger.info((String)"checking for updates");
        if (monitor != null) {
            monitor.setStatusText(i18n.tr("Suche nach Updates"));
        }
        try {
            if (Application.getPluginLoader().getInstalledPlugins().size() == 0) {
                Logger.info((String)"no plugins installed");
                if (monitor != null) {
                    monitor.setStatus(4);
                    monitor.setPercentComplete(100);
                    monitor.setStatusText(i18n.tr("Derzeit sind keine Plugins installiert"));
                }
                return null;
            }
            TreeMap<String, List<UpdateStatus>> updates = new TreeMap<String, List<UpdateStatus>>();
            RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
            List<URL> urls = service.getRepositories();
            for (URL url : urls) {
                Logger.info((String)("checking repository " + url));
                try {
                    if (monitor != null) {
                        monitor.log(i18n.tr("Pr\u00fcfe {0}", url.toString()));
                        monitor.addPercentComplete(10);
                    }
                    Repository repo = service.open(url);
                    List<PluginData> plugins = repo.getPlugins();
                    for (PluginData pluginData : plugins) {
                        if (monitor != null) {
                            monitor.addPercentComplete(5);
                        }
                        try {
                            List<UpdateStatus> list;
                            UpdateStatus status = new UpdateStatus(pluginData);
                            if (!status.available) continue;
                            Logger.info((String)("update available for plugin " + pluginData.getName()));
                            if (monitor != null) {
                                monitor.log("  " + i18n.tr("Update gefunden: {0}", pluginData.getName()));
                                monitor.addPercentComplete(5);
                            }
                            if ((list = updates.get(pluginData.getName())) == null) {
                                list = new ArrayList<UpdateStatus>();
                                updates.put(pluginData.getName(), list);
                            }
                            list.add(status);
                        }
                        catch (Exception e) {
                            if (monitor != null) {
                                monitor.log("  " + i18n.tr("Fehler beim Pr\u00fcfen des Plugins {0}: {1}", new String[]{pluginData.getName(), e.getMessage()}));
                            }
                            Logger.error((String)("error while checking plugin " + pluginData.getName()), (Throwable)e);
                        }
                    }
                    for (List list : updates.values()) {
                        Collections.sort(list, new Comparator<UpdateStatus>(){

                            @Override
                            public int compare(UpdateStatus o1, UpdateStatus o2) {
                                return o2.plugin.getAvailableVersion().compareTo(o1.plugin.getAvailableVersion());
                            }
                        });
                    }
                }
                catch (Exception e) {
                    if (monitor != null) {
                        monitor.log(i18n.tr("Fehler beim Pr\u00fcfen des Repository: {0}", e.getMessage()));
                    }
                    Logger.error((String)("error while checking repository " + url), (Throwable)e);
                }
            }
            if (monitor != null) {
                monitor.setStatus(4);
                monitor.setPercentComplete(100);
                monitor.setStatusText(i18n.tr("Suche beendet. Gefundene Updates: {0}", String.valueOf(updates.size())));
            }
            return updates.size() > 0 ? updates : null;
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw (ApplicationException)((Object)e);
            }
            Logger.error((String)"error while searching for updates", (Throwable)e);
            throw new ApplicationException(i18n.tr("Suche nach Updates erfolglos: {0}", e.getMessage()));
        }
    }

    private class Worker
    extends TimerTask {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            I18N i18n = Application.getI18n();
            long lastRun = settings.getLong("lastrun", 0L);
            long nextRun = lastRun + (long)(UpdateService.this.getUpdateInterval() * 24 * 60 * 60) * 1000L;
            long now = System.currentTimeMillis();
            Logger.info((String)"check for updates needed?");
            if (nextRun > now) {
                Logger.info((String)("no, last check: " + new Date(lastRun) + ", next check: " + new Date(nextRun)));
                return;
            }
            Logger.info((String)("last check was " + (String)(lastRun == 0L ? "<never>" : "on " + new Date(lastRun))));
            try {
                StringBuffer names;
                if (Application.getPluginLoader().getInstalledPlugins().size() == 0) {
                    Logger.info((String)"no plugins installed, no need to check for updates");
                    return;
                }
                if (!Application.inServerMode()) {
                    GUI.getStatusBar().startProgress();
                }
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Suche nach Updates"), 2));
                TreeMap<String, List<UpdateStatus>> states = UpdateService.this.findUpdateStates(null);
                if (states == null || states.size() == 0) {
                    return;
                }
                if (UpdateService.this.getUpdateInstall()) {
                    names = new StringBuffer();
                    for (List<UpdateStatus> list : states.values()) {
                        if (list.size() == 0) continue;
                        UpdateStatus status = list.get(0);
                        try {
                            PluginData pd = status.plugin;
                            Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Lade Update f\u00fcr Plugin {0}", pd.getName()), 0));
                            Repository repo = pd.getPluginGroup().getRepository();
                            repo.download(pd, false);
                            status.update();
                            names.append(pd.getName());
                            names.append("\n");
                            Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Update f\u00fcr Plugin {0} installiert", pd.getName()), 0));
                        }
                        catch (Exception e) {
                            Logger.error((String)"unable to download plugin", (Throwable)e);
                        }
                    }
                    TextMessage qm = new TextMessage(i18n.tr("Updates installiert"), i18n.tr("F\u00fcr folgende Plugins wurden Updates installiert:\n\n{0}\nBitte starten Sie Jameica neu.", names.toString()));
                    Application.getMessagingFactory().getMessagingQueue("jameica.popup").sendMessage(qm);
                } else {
                    names = new StringBuffer();
                    int count = 0;
                    HashSet<String> unique = new HashSet<String>();
                    for (List<UpdateStatus> list : states.values()) {
                        if (list.size() == 0) continue;
                        UpdateStatus status = list.get(0);
                        if (status.notified) continue;
                        status.update();
                        String s = status.plugin.getName();
                        if (unique.contains(s)) continue;
                        unique.add(s);
                        names.append(s);
                        names.append("\n");
                        ++count;
                    }
                    if (count > 0) {
                        TextMessage qm = new TextMessage(i18n.tr("Neue Updates verf\u00fcgbar"), i18n.tr("F\u00fcr folgende Plugins sind Updates verf\u00fcgbar:\n\n{0}", names.toString()));
                        Application.getMessagingFactory().getMessagingQueue("jameica.popup").sendMessage(qm);
                    }
                }
                String text = states.size() == 1 ? i18n.tr("1 Update gefunden") : i18n.tr("{0} Updates gefunden", String.valueOf(states.size()));
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(text, 0));
            }
            catch (Exception e) {
                Logger.error((String)"error while checking for updates", (Throwable)e);
            }
            finally {
                Logger.info((String)("save check date: " + new Date(now)));
                settings.setAttribute("lastrun", now);
                if (!Application.inServerMode()) {
                    GUI.getStatusBar().stopProgress();
                }
            }
        }
    }

    private class UpdateStatus {
        private PluginData plugin = null;
        private boolean available = false;
        private boolean notified = false;

        private UpdateStatus(PluginData p) throws RemoteException {
            Dependency jd;
            this.plugin = p;
            Logger.debug((String)("checking plugin " + this.plugin.getName()));
            Version vc = this.plugin.getInstalledVersion();
            Version va = this.plugin.getAvailableVersion();
            if (vc == null) {
                Logger.debug((String)"not installed");
                return;
            }
            if (va == null) {
                Logger.debug((String)"no version available");
                return;
            }
            Manifest remoteMf = this.plugin.getManifest();
            Manifest localMf = this.plugin.getInstalledManifest();
            if (localMf.validateHomepage()) {
                try {
                    String homepage;
                    URL download = this.plugin.getDownloadUrl();
                    if (download == null) {
                        Logger.debug((String)"no download url available");
                        return;
                    }
                    if (localMf != null && StringUtils.trimToNull((String)(homepage = localMf.getHomepage())) != null) {
                        URL home = new URL(homepage);
                        if (!Objects.equals(download.getHost().toLowerCase(), home.getHost().toLowerCase())) {
                            Logger.warn((String)("download url \"" + download + "\" does not belong to plugin homepage \"" + homepage + "\""));
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.warn((String)("unable to check download url for " + this.plugin.getName() + ": " + e.getMessage()));
                    return;
                }
            }
            if (!(jd = remoteMf.getJameicaDependency()).check()) {
                Logger.debug((String)("required jameica version not available. required: " + jd));
                return;
            }
            RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
            try {
                ResolverResult result = service.resolve(this.plugin);
                if (result.getMissing().size() > 0) {
                    Logger.warn((String)("plugin " + this.plugin.getName() + " has missing dependencies: " + StringUtils.join(result.getMissing(), (String)", ")));
                    return;
                }
            }
            catch (ApplicationException ae) {
                Logger.warn((String)("unable to check update dependencies for plugin " + this.plugin.getName() + ": " + ae.getMessage()));
                return;
            }
            Version vn = new Version(settings.getString(this.plugin.getName(), vc.toString()));
            Logger.debug((String)("checking version. current: " + vc + ", available: " + va + ", last notified: " + vn));
            this.available = va.compareTo(vc) > 0;
            boolean bl = this.notified = vn.compareTo(va) >= 0;
            if (this.available) {
                Logger.info((String)("found update for plugin " + this.plugin.getName() + " from " + vc + " to " + va));
            }
        }

        private void update() throws RemoteException {
            if (!this.available) {
                return;
            }
            Version va = this.plugin.getAvailableVersion();
            if (va != null) {
                Logger.info((String)("set notified version from " + settings.getString(this.plugin.getName(), null) + " to " + va));
                settings.setAttribute(this.plugin.getName(), va.toString());
            }
        }
    }
}

