/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.internal.parts.SysTray;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.MessagingService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Shell;

public class SystrayService
implements Bootable {
    private static final Settings settings = new Settings(SystrayService.class);
    private SysTray systray;

    public Class<Bootable>[] depends() {
        return new Class[]{BeanService.class, MessagingService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        if (Application.inServerMode()) {
            return;
        }
        Application.getMessagingFactory().registerMessageConsumer(new InitMessageConsumer());
        BeanService bs = (BeanService)loader.getBootable(BeanService.class);
        this.systray = bs.get(SysTray.class);
    }

    public void setNewActivity(boolean b) {
        if (this.systray != null) {
            this.systray.setNewActivity(b);
        }
    }

    public void shutdown() {
    }

    public boolean isEnabled() {
        return settings.getBoolean("enabled", false);
    }

    public void setEnabled(boolean enabled) {
        settings.setAttribute("enabled", enabled);
        this.update();
    }

    public boolean isMinimizeToSystray() {
        return settings.getBoolean("minimize", false);
    }

    public void setMinimizeToSystray(boolean enabled) {
        settings.setAttribute("minimize", enabled);
    }

    public void update() {
        if (this.isEnabled()) {
            this.systray.start();
        } else {
            this.systray.stop();
        }
    }

    private void init() {
        this.update();
        GUI.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                Shell shell = GUI.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                if (!SystrayService.this.isEnabled() || !SystrayService.this.isMinimizeToSystray()) {
                    return;
                }
                e.doit = false;
                this.shellIconified(e);
            }

            public void shellIconified(ShellEvent e) {
                Shell shell = GUI.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                if (!SystrayService.this.isEnabled() || !SystrayService.this.isMinimizeToSystray()) {
                    return;
                }
                if (shell.getData("__systray-minimize") != null) {
                    return;
                }
                Logger.info((String)"shell iconified");
                shell.setData("__systray-minimize", (Object)Boolean.TRUE);
                shell.setVisible(false);
            }
        });
    }

    private class InitMessageConsumer
    implements MessageConsumer {
        private InitMessageConsumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{SystemMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            SystemMessage msg = (SystemMessage)message;
            if (msg.getStatusCode() == 1) {
                SystrayService.this.init();
            }
        }
    }
}

