/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import java.util.HashMap;
import java.util.Map;

public class SysPropertyService
implements Bootable {
    private static final Settings settings = new Settings(SysPropertyService.class);
    private static final Map<String, String> presets = new HashMap<String, String>(){
        {
            this.put("java.net.preferIPv4Stack", "true");
        }
    };

    public Class[] depends() {
        return new Class[]{LogService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        for (Map.Entry<String, String> e : presets.entrySet()) {
            String name = e.getKey();
            String value = settings.getString(name, e.getValue());
            Logger.info((String)("setting sys property (from presets): " + name + ": " + value));
            System.setProperty(name, value);
        }
        for (String name : settings.getAttributes()) {
            if (presets.containsKey(name)) continue;
            String value = settings.getString(name, null);
            if (value == null) {
                Logger.warn((String)("missing value for sys property " + name));
                continue;
            }
            Logger.info((String)("setting sys property: " + name + ": " + value));
            System.setProperty(name, value);
        }
    }

    public void shutdown() {
    }
}

