/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.services.SSLService;
import de.willuhn.logging.Logger;
import javax.net.ssl.HttpsURLConnection;

public class SSLSocketFactoryService
implements Bootable {
    public Class[] depends() {
        return new Class[]{LogService.class, SSLService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        try {
            Logger.info((String)"applying jameica's ssl socket factory");
            SSLService service = (SSLService)loader.getBootable(SSLService.class);
            HttpsURLConnection.setDefaultSSLSocketFactory(service.getSSLFactory().getSSLContext().getSocketFactory());
        }
        catch (SkipServiceException se) {
            throw se;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
    }
}

