/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.internal.dialogs.PluginSourceDialog;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.messaging.TextMessage;
import de.willuhn.jameica.plugin.Dependency;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.plugin.ZippedPlugin;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.DeployService;
import de.willuhn.jameica.services.TransportService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.transport.Transport;
import de.willuhn.jameica.update.PluginData;
import de.willuhn.jameica.update.PluginGroup;
import de.willuhn.jameica.update.Repository;
import de.willuhn.jameica.update.RepositorySearchResult;
import de.willuhn.jameica.update.ResolverResult;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.security.Signature;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import de.willuhn.util.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class RepositoryService
implements Bootable {
    private static final int ERRORCOUNT_MAX = 5;
    public static final String SYSTEM_REPOSITORY = "https://www.willuhn.de/products/jameica/updates";
    public static final String[] WELL_KNOWN = new String[]{"https://www.willuhn.de/products/jameica/updates/extensions", "https://openjverein.github.io/jameica-repository", "https://scripting-updates.derrichter.de/", "https://www.open4me.de/hibiscus/", "https://hibiscus.tvbrowser.org/"};
    private static final Settings settings = new Settings(RepositoryService.class);
    private Session resolveCache = new Session(600000L);

    public Class<Bootable>[] depends() {
        return new Class[]{BeanService.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(BootLoader arg0, Bootable arg1) throws SkipServiceException {
        if (settings.getString("wellknown.added", null) == null) {
            try {
                for (String s : WELL_KNOWN) {
                    Logger.info((String)("adding well-known additional repository " + s));
                    URL url = new URL(s);
                    if (this.contains(url)) continue;
                    this.addRepository(url);
                }
            }
            catch (Exception e) {
                Logger.error((String)"error while adding repository", (Throwable)e);
            }
            finally {
                settings.setAttribute("wellknown.added", DateUtil.DEFAULT_FORMAT.format(new Date()));
            }
        }
    }

    public void shutdown() {
    }

    public List<URL> getRepositories(boolean all) {
        String[] urls = settings.getList("repository.url", new String[0]);
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            list.add(new URL(SYSTEM_REPOSITORY));
        }
        catch (Exception e) {
            Logger.error((String)"SUSPEKT! unable to add system repository https://www.willuhn.de/products/jameica/updates", (Throwable)e);
        }
        for (String url : urls) {
            if (url == null || url.length() == 0 || url.equalsIgnoreCase(SYSTEM_REPOSITORY)) continue;
            try {
                URL u = new URL(url);
                if (!all && !this.isEnabled(u)) continue;
                list.add(u);
            }
            catch (Exception e) {
                Logger.error((String)("invalid url: " + url + ", skipping"), (Throwable)e);
            }
        }
        return list;
    }

    public List<URL> getRepositories() {
        return this.getRepositories(false);
    }

    public ResolverResult resolve(PluginData plugin) throws ApplicationException {
        if (plugin == null) {
            throw new ApplicationException(Application.getI18n().tr("Kein Plugin angegeben"));
        }
        ResolverResult result = new ResolverResult(plugin);
        if (plugin.isInstalledVersion()) {
            return result;
        }
        for (Dependency d : plugin.getManifest().getDirectDependencies()) {
            if (d.check()) continue;
            PluginData pd = this.search(d);
            if (pd == null) {
                result.getMissing().add(d);
                continue;
            }
            result.getResolved().add(pd);
            result.merge(this.resolve(pd));
        }
        return result;
    }

    public void downloadMulti(final PluginData ... plugins) throws ApplicationException {
        final I18N i18n = Application.getI18n();
        if (plugins == null || plugins.length == 0) {
            throw new ApplicationException(i18n.tr("Keine zu installierenden Plugins angegeben"));
        }
        final DeployService ds = (DeployService)Application.getBootLoader().getBootable(DeployService.class);
        final TransportService ts = (TransportService)Application.getBootLoader().getBootable(TransportService.class);
        try {
            String q;
            ArrayList<String> missing = new ArrayList<String>();
            for (PluginData data : plugins) {
                String name = data.getName();
                Logger.info((String)("checking if plugin " + name + " is signed"));
                Transport t = ts.getTransport(data.getSignatureUrl());
                if (t.exists()) continue;
                missing.add(name);
            }
            if (missing.size() == 1) {
                q = i18n.tr("Das Plugin \"{0}\" wurde vom Herausgeber nicht signiert.\nM\u00f6chten Sie es dennoch installieren?", (String)missing.get(0));
                if (!Application.getCallback().askUser(q, false)) {
                    throw new OperationCanceledException(i18n.tr("Vorgang abgebrochen"));
                }
            }
            if (missing.size() > 1) {
                q = i18n.tr("Die Plugins \"{0}\" wurden vom Herausgeber nicht signiert.\nM\u00f6chten Sie sie dennoch installieren?", StringUtils.join(missing, (String)", "));
                if (!Application.getCallback().askUser(q, false)) {
                    throw new OperationCanceledException(i18n.tr("Vorgang abgebrochen"));
                }
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            Logger.error((String)"error while checking signatures", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen der Signaturen: {0}", e.getMessage()));
        }
        BackgroundTask t = new BackgroundTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(ProgressMonitor monitor) throws ApplicationException {
                try {
                    File dir = Application.getConfig().getUpdateDir();
                    PluginSource source = null;
                    for (PluginData data : plugins) {
                        String name = data.getName();
                        File archive = null;
                        File sig = null;
                        Transport t = null;
                        boolean update = false;
                        try {
                            Logger.info((String)("checking if plugin " + name + " is signed"));
                            t = ts.getTransport(data.getSignatureUrl());
                            if (t.exists()) {
                                sig = new File(dir, name + ".zip.sha1");
                                t.get(new BufferedOutputStream(new FileOutputStream(sig)), null);
                                Logger.info((String)("created signature file " + sig));
                            }
                            t = ts.getTransport(data.getDownloadUrl());
                            archive = new File(dir, name + ".zip");
                            Logger.info((String)("creating deploy file " + archive));
                            t.get(new BufferedOutputStream(new FileOutputStream(archive)), monitor);
                            if (sig != null) {
                                RepositoryService.this.checkSignature(data, archive, sig);
                            }
                            ZippedPlugin zp = new ZippedPlugin(archive);
                            Manifest mf = zp.getManifest();
                            Manifest installed = Application.getPluginLoader().getManifestByName(mf.getName());
                            if (installed != null) {
                                ds.update(installed, zp, monitor);
                                update = true;
                                continue;
                            }
                            if (!Application.inServerMode() && source == null) {
                                PluginSourceDialog d = new PluginSourceDialog(1, null);
                                source = (PluginSource)d.open();
                            }
                            ds.deploy(zp, source, monitor, true);
                        }
                        finally {
                            if (!update && archive != null && archive.exists()) {
                                Logger.info((String)("deleting " + archive));
                                archive.delete();
                            }
                            if (sig != null && sig.exists()) {
                                Logger.info((String)("delete signature " + sig));
                                sig.delete();
                            }
                        }
                    }
                    monitor.setStatus(4);
                    TextMessage msg = new TextMessage(i18n.tr("{0} Plugins heruntergeladen", Integer.toString(plugins.length)), i18n.tr("Die Installation erfolgt beim n\u00e4chsten Neustart von Jameica."));
                    Application.getMessagingFactory().getMessagingQueue("jameica.popup").sendMessage(msg);
                }
                catch (ApplicationException ae) {
                    throw ae;
                }
                catch (OperationCanceledException oce) {
                    throw new ApplicationException(oce.getMessage());
                }
                catch (Exception e) {
                    Logger.error((String)"error while downloading file", (Throwable)e);
                    throw new ApplicationException(i18n.tr("Fehler beim Herunterladen der Plugins: {0}", e.getMessage()));
                }
            }

            @Override
            public boolean isInterrupted() {
                return false;
            }

            @Override
            public void interrupt() {
            }
        };
        Application.getController().start(t);
    }

    public void checkSignature(PluginData plugin, File archive, File sig) throws Exception {
        block5: {
            Logger.info((String)("checking signature " + sig + " of file " + archive));
            PluginGroup group = plugin.getPluginGroup();
            X509Certificate cert = group.getCertificate();
            if (cert == null) {
                Logger.error((String)("plugin " + plugin.getName() + " may be signed, but no certificate found for verification in repository group " + group.getName() + " of " + group.getRepository().getUrl()));
                throw new ApplicationException(Application.getI18n().tr("Repository enth\u00e4lt kein g\u00fcltiges Zertifikat \"{0}\". Installation abgebrochen", plugin.getName()));
            }
            BufferedInputStream is1 = null;
            BufferedInputStream is2 = null;
            try {
                is2 = new BufferedInputStream(new FileInputStream(sig));
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int read = 0;
                while ((read = ((InputStream)is2).read(buf)) != -1) {
                    bos.write(buf, 0, read);
                }
                is1 = new BufferedInputStream(new FileInputStream(archive));
                if (!Signature.verifiy((InputStream)is1, (PublicKey)cert.getPublicKey(), (byte[])bos.toByteArray())) break block5;
                Logger.info((String)("signature of plugin " + plugin.getName() + " OK"));
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is1, is2});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{is1, is2});
            return;
        }
        throw new ApplicationException(Application.getI18n().tr("Signatur des Plugins \"{0}\" ung\u00fcltig. Installation abgebrochen", plugin.getName()));
    }

    public List<RepositorySearchResult> search(URL url, String query) throws ApplicationException {
        ArrayList<RepositorySearchResult> result = new ArrayList<RepositorySearchResult>();
        List<URL> repos = url != null ? Arrays.asList(url) : this.getRepositories();
        for (URL u : repos) {
            try {
                result.add(new RepositorySearchResult(this.open(u), query));
            }
            catch (ApplicationException e) {
                if (repos.size() > 1) {
                    Logger.error((String)"skipping invalid repository", (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        return result;
    }

    private PluginData search(Dependency dep) throws ApplicationException {
        if (dep == null) {
            throw new ApplicationException(Application.getI18n().tr("Keine Abh\u00e4ngigkeit angegeben"));
        }
        String key = dep.getName() + "." + dep.getVersion();
        Object result = this.resolveCache.get((Object)key);
        if (result != null) {
            return result instanceof PluginData ? (PluginData)result : null;
        }
        ArrayList<PluginData> candidates = new ArrayList<PluginData>();
        for (URL u : this.getRepositories()) {
            try {
                Repository r = this.open(u);
                for (PluginData d : r.getPlugins()) {
                    if (!ObjectUtils.equals((Object)d.getName(), (Object)dep.getName()) || !d.getAvailableVersion().compliesTo(dep.getVersion())) continue;
                    candidates.add(d);
                }
            }
            catch (Exception e) {
                Logger.info((String)("unable to open repository " + u + ": " + e.getMessage() + " skipping"));
                Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)e);
            }
        }
        Collections.sort(candidates, new Comparator<PluginData>(){

            @Override
            public int compare(PluginData o1, PluginData o2) {
                return o2.getAvailableVersion().compareTo(o1.getAvailableVersion());
            }
        });
        for (PluginData d : candidates) {
            Manifest mf = d.getManifest();
            Dependency jd = mf.getJameicaDependency();
            if (!jd.check()) continue;
            this.resolveCache.put((Object)key, (Object)d);
            return d;
        }
        this.resolveCache.put((Object)key, new Object());
        return null;
    }

    public Repository open(URL url) throws ApplicationException {
        ApplicationException e = null;
        try {
            Repository repository = new Repository(url);
            return repository;
        }
        catch (ApplicationException ae) {
            e = ae;
            throw ae;
        }
        finally {
            this.updateRepositoryState(url, e);
        }
    }

    public boolean isEnabled(URL url) {
        return settings.getBoolean(url.toString() + ".enabled", true);
    }

    public void setEnabled(URL url, boolean enabled) {
        if (this.isEnabled(url) == enabled) {
            Logger.debug((String)("repository " + url + " no state change: " + enabled));
            return;
        }
        Logger.info((String)("repository " + url + " enabled: " + enabled));
        settings.setAttribute(url.toString() + ".enabled", enabled);
        I18N i18n = Application.getI18n();
        Application.getMessagingFactory().getMessagingQueue("jameica.update.repository." + (enabled ? "enabled" : "disabled")).sendMessage(new QueryMessage(url));
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr(enabled ? "Repository-URL aktiviert" : "Repository-URL deaktiviert"), 0));
    }

    private void updateRepositoryState(URL url, ApplicationException ae) {
        try {
            int current = settings.getInt(url.toString() + ".errorcount", 0);
            if (current == 0 && ae == null) {
                return;
            }
            if (ae == null) {
                Logger.info((String)("reset error count for repository " + url));
                settings.setAttribute(url.toString() + ".errorcount", 0);
                return;
            }
            int i = current + 1;
            Logger.warn((String)("increasing error count for repository " + url + " to " + i));
            settings.setAttribute(url.toString() + ".errorcount", i);
            if (i >= 5) {
                Logger.error((String)"maximum error count (5) reached for repository, will be disabled");
                this.setEnabled(url, false);
                settings.setAttribute(url.toString() + ".errorcount", 0);
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to update repository state", (Throwable)e);
        }
    }

    public void addRepository(URL url) throws ApplicationException {
        if (url == null) {
            throw new ApplicationException(Application.getI18n().tr("Keine Repository-URL angegeben"));
        }
        if (this.contains(url)) {
            throw new ApplicationException(Application.getI18n().tr("Repository-URL {0} existiert bereits", url.toString()));
        }
        List<URL> list = this.getRepositories(true);
        list.add(url);
        this.setRepositories(list);
        Logger.info((String)("repository " + url + " added"));
        Application.getMessagingFactory().getMessagingQueue("jameica.update.repository.add").sendMessage(new QueryMessage(url));
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Repository-URL hinzugef\u00fcgt"), 0));
    }

    public void removeRepository(URL url) throws ApplicationException {
        if (url == null) {
            throw new ApplicationException(Application.getI18n().tr("Keine Repository-URL angegeben"));
        }
        if (!this.contains(url)) {
            Logger.warn((String)("repository " + url + " does not exist"));
            return;
        }
        List<URL> list = this.getRepositories(true);
        list.remove(url);
        this.setRepositories(list);
        String s = url.toString();
        settings.setAttribute(s + ".enabled", null);
        settings.setAttribute(s + ".errorcount", null);
        Logger.info((String)("repository " + url + " removed"));
        Application.getMessagingFactory().getMessagingQueue("jameica.update.repository.remove").sendMessage(new QueryMessage(url));
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Repository-URL gel\u00f6scht"), 0));
    }

    public boolean contains(URL url) {
        if (url == null) {
            return false;
        }
        String s = url.toString();
        List<URL> list = this.getRepositories(true);
        for (URL u : list) {
            if (!u.toString().equals(s)) continue;
            return true;
        }
        return false;
    }

    private void setRepositories(List<URL> list) {
        Hashtable<String, URL> duplicates = new Hashtable<String, URL>();
        ArrayList<String> urls = new ArrayList<String>();
        if (list != null && list.size() > 0) {
            for (URL u : list) {
                if (duplicates.containsKey(u.toString())) {
                    Logger.warn((String)("found duplicate repository " + u + ", skipping"));
                    continue;
                }
                duplicates.put(u.toString(), u);
                String s = u.toString();
                if (s == null || s.length() == 0 || s.equalsIgnoreCase(SYSTEM_REPOSITORY)) continue;
                urls.add(s);
            }
        }
        settings.setAttribute("repository.url", urls.size() > 0 ? urls.toArray(new String[urls.size()]) : null);
    }
}

