/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Config;
import de.willuhn.logging.Logger;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;

public class ProxyService
implements Bootable {
    public Class[] depends() {
        return new Class[]{LogService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        Config config = Application.getConfig();
        if (Application.getConfig().getUseSystemProxy()) {
            Logger.info((String)"Using system proxy settings");
            System.setProperty("java.net.useSystemProxies", "true");
            Logger.info((String)"Trying to determine system proxies");
            InetSocketAddress http = this.determineProxy("http://www.willuhn.de/");
            InetSocketAddress https = this.determineProxy("https://www.willuhn.de/");
            if (http != null) {
                Logger.info((String)("  Found HTTP proxy: " + http));
            }
            if (https != null) {
                Logger.info((String)("  Found HTTPS proxy: " + https));
            }
            return;
        }
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.info((String)("Applying proxy settings: " + proxyHost + ":" + proxyPort));
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", "" + proxyPort);
        }
        proxyHost = config.getHttpsProxyHost();
        proxyPort = config.getHttpsProxyPort();
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            Logger.info((String)("Applying https proxy settings: " + proxyHost + ":" + proxyPort));
            System.setProperty("https.proxyHost", proxyHost);
            System.setProperty("https.proxyPort", "" + proxyPort);
        }
    }

    public void shutdown() {
    }

    private InetSocketAddress determineProxy(String url) {
        try {
            List<Proxy> proxies = ProxySelector.getDefault().select(new URI(url));
            for (Proxy p : proxies) {
                Proxy.Type type = p.type();
                SocketAddress address = p.address();
                if (type == null || address == null || type != Proxy.Type.HTTP || !(address instanceof InetSocketAddress)) continue;
                return (InetSocketAddress)address;
            }
        }
        catch (Exception e) {
            Logger.error((String)("unable to determine proxy for " + url));
        }
        return null;
    }
}

