/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.ClassService;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.MultipleClassLoader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PluginSourceService
implements Bootable {
    private static final Settings settings = new Settings(PluginSource.class, false);
    private List<PluginSource> sources = null;

    public Class[] depends() {
        return new Class[]{LogService.class, ClassService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
    }

    public void shutdown() {
    }

    public PluginSource getDefault() {
        return this.getSource(PluginSource.Type.DEFAULT);
    }

    public PluginSource getSource(PluginSource.Type type) {
        if (type == null) {
            Logger.warn((String)"no type for plugin source given");
            return null;
        }
        List<PluginSource> sources = this.getSources();
        for (PluginSource s : sources) {
            if (s.getType() != type) continue;
            return s;
        }
        return null;
    }

    public List<PluginSource> getWritableSources() {
        LinkedList<PluginSource> sources = new LinkedList<PluginSource>();
        for (PluginSource source : this.getSources()) {
            if (!source.canWrite()) continue;
            sources.add(source);
        }
        return sources;
    }

    public synchronized List<PluginSource> getSources() {
        if (this.sources != null) {
            return this.sources;
        }
        this.sources = new LinkedList<PluginSource>();
        try {
            Class[] classes;
            MultipleClassLoader loader = Application.getClassLoader();
            BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            for (Class c : classes = loader.getClassFinder().findImplementors(PluginSource.class)) {
                try {
                    PluginSource source = (PluginSource)beanService.get(c);
                    if (!settings.getBoolean(source.getType() + ".enabled", true)) {
                        Logger.info((String)("plugin-source " + source.getType() + " disabled by admin-directive, skipping"));
                        continue;
                    }
                    this.sources.add(source);
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load plugin source " + c + " - skipping"), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to load plugin sources", (Throwable)e);
        }
        Collections.sort(this.sources);
        return this.sources;
    }
}

