/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.services.SecurityManagerService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.JameicaException;
import de.willuhn.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class LockService
implements Bootable {
    private RandomAccessFile raf = null;
    private FileChannel channel = null;
    private FileLock lock = null;
    private File file = null;
    private boolean unclean = false;
    private boolean locked = false;

    public Class[] depends() {
        return new Class[]{SecurityManagerService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        if (Application.getStartupParams().isIgnoreLockfile()) {
            return;
        }
        this.file = new File(Application.getConfig().getWorkDir(), "jameica.lock");
        try {
            boolean lockFound = this.file.exists();
            if (!lockFound) {
                Logger.info((String)("creating lockfile " + this.file));
                if (!this.file.createNewFile()) {
                    throw new IOException("unable to create lock file " + this.file + ", is " + this.file.getParent() + " readonly?");
                }
            } else {
                Logger.info((String)("lockfile " + this.file + " exists, checking"));
            }
            this.raf = new RandomAccessFile(this.file, "rw");
            this.channel = this.raf.getChannel();
            try {
                this.lock = this.channel.tryLock();
                if (this.lock == null) {
                    throw new OverlappingFileLockException();
                }
                if (lockFound) {
                    this.unclean = true;
                    Logger.warn((String)"detected unclean shutdown from previous run");
                }
                this.locked = true;
                Logger.info((String)(this.file + " successfully locked"));
            }
            catch (OverlappingFileLockException e) {
                Logger.error((String)(this.file + " is already locked - asking user, what to do"));
                if (!Application.getCallback().lockExists(this.file.getAbsolutePath())) {
                    System.exit(1);
                }
            }
        }
        catch (IOException e) {
            Logger.error((String)("unable to create/lock " + this.file), (Throwable)e);
            if (this.locked) {
                IOUtil.close((Closeable[])new Closeable[]{this.channel, this.raf});
                this.file.delete();
            }
            throw new JameicaException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void shutdown() {
        try {
            if (this.lock != null && this.locked) {
                this.lock.release();
            }
            if (!this.locked) return;
        }
        catch (Exception e) {
            try {
                Logger.error((String)"unable to release lock", (Throwable)e);
                if (!this.locked) return;
            }
            catch (Throwable throwable) {
                if (!this.locked) throw throwable;
                IOUtil.close((Closeable[])new Closeable[]{this.channel, this.raf});
                this.file.delete();
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{this.channel, this.raf});
            this.file.delete();
            return;
        }
        IOUtil.close((Closeable[])new Closeable[]{this.channel, this.raf});
        this.file.delete();
        return;
    }

    public boolean foundUncleanShutdown() {
        return this.unclean;
    }
}

