/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.io.FileCopy;
import de.willuhn.io.FileFinder;
import de.willuhn.io.FileUtil;
import de.willuhn.io.ZipExtractor;
import de.willuhn.jameica.messaging.PluginMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.plugin.ZippedPlugin;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.services.PluginSourceService;
import de.willuhn.jameica.services.SecurityManagerService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.zip.ZipFile;

public class DeployService
implements Bootable {
    private Settings settings = new Settings(DeployService.class);

    public Class[] depends() {
        return new Class[]{LogService.class, PluginSourceService.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        Logger.info((String)"searching for uninstallable plugins");
        final PluginSourceService sources = (PluginSourceService)loader.getBootable(PluginSourceService.class);
        List<PluginSource> list = sources.getWritableSources();
        for (PluginSource s : list) {
            this.cleanup(s);
        }
        Logger.info((String)"searching for updatable plugins");
        FileFinder finder = new FileFinder(Application.getConfig().getUpdateDir());
        finder.extension(".zip");
        File[] files = finder.find();
        if (files == null || files.length == 0) {
            return;
        }
        final ProgressMonitor monitor = loader.getMonitor();
        final ProgressMonitor proxy = new ProgressMonitor(){

            public void setStatusText(String s) {
                monitor.setStatusText(s);
            }

            public void setStatus(int s) {
                monitor.setStatus(s);
            }

            public void setPercentComplete(int complete) {
            }

            public void log(String s) {
                monitor.log(s);
            }

            public int getPercentComplete() {
                return monitor.getPercentComplete();
            }

            public void addPercentComplete(int complete) {
            }
        };
        for (File file : files) {
            Logger.info((String)("  " + file));
            try {
                final ZippedPlugin plugin = new ZippedPlugin(file);
                String s = this.settings.getString(file.getCanonicalPath(), null);
                final PluginSource.Type type = s != null ? PluginSource.Type.valueOf(s) : null;
                SecurityManagerService service = (SecurityManagerService)Application.getBootLoader().getBootable(SecurityManagerService.class);
                Exception e = service.getSecurityManager().doPrivileged(new PrivilegedAction<Exception>(){

                    @Override
                    public Exception run() {
                        try {
                            DeployService.this.deploy(plugin, sources.getSource(type), proxy);
                            return null;
                        }
                        catch (Exception e) {
                            return e;
                        }
                    }

                    public String toString() {
                        return "deploy " + plugin.getFile();
                    }
                });
                if (e != null) {
                    throw e;
                }
                this.settings.setAttribute(file.getCanonicalPath(), null);
            }
            catch (ApplicationException ae) {
                Logger.error((String)("unable to deploy " + file + ": " + ae.getMessage()));
            }
            catch (Exception e) {
                Logger.error((String)("unable to deploy " + file), (Throwable)e);
            }
            finally {
                Logger.info((String)("deleting " + file));
                if (!file.delete()) {
                    Logger.error((String)("FATAL: unable to delete " + file));
                }
            }
        }
    }

    public void update(Manifest current, ZippedPlugin plugin, ProgressMonitor monitor) {
        I18N i18n = Application.getI18n();
        try {
            if (plugin == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die ZIP-Datei mit dem zu aktualisierenden Plugin"));
            }
            if (current == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie das zu aktualisierende Plugin"));
            }
            Manifest mf = plugin.getManifest();
            if (!current.getName().equals(mf.getName())) {
                throw new ApplicationException(i18n.tr("Die ZIP-Datei enth\u00e4lt nicht das zu aktualisierende Plugin"));
            }
            mf.canDeploy(false);
            monitor.setStatusText(i18n.tr("Aktualisiere Plugin {0}", current.getName()));
            File source = plugin.getFile();
            File target = new File(Application.getConfig().getUpdateDir(), source.getName());
            if (!source.equals(target)) {
                FileCopy.copy((File)source, (File)target, (boolean)true);
            }
            this.settings.setAttribute(target.getCanonicalPath(), current.getPluginSource().name());
            monitor.addPercentComplete(50);
            Application.getPluginLoader().markForDelete(current);
            monitor.addPercentComplete(20);
            monitor.setStatus(4);
            monitor.setPercentComplete(100);
            monitor.setStatusText(i18n.tr("Plugin aktualisiert"));
            Logger.warn((String)("plugin " + current.getName() + " updated"));
            Application.getMessagingFactory().sendMessage(new PluginMessage(mf, PluginMessage.Event.UPDATED));
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Plugin aktualisiert, bitte starten Sie Jameica neu"), 0));
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (!(e instanceof ApplicationException)) {
                Logger.error((String)"unable to update plugin", (Throwable)e);
                msg = i18n.tr("Fehler beim Aktualisieren: {0}", msg);
            }
            monitor.setStatus(3);
            monitor.setStatusText(msg);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(msg, 1));
        }
    }

    public void deploy(ZippedPlugin plugin, PluginSource source, ProgressMonitor monitor) {
        this.deploy(plugin, source, monitor, false);
    }

    public void deploy(ZippedPlugin plugin, PluginSource source, ProgressMonitor monitor, boolean multi) {
        I18N i18n = Application.getI18n();
        try {
            if (plugin == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie das zu installierende Plugin"));
            }
            if (source == null) {
                PluginSourceService sources = (PluginSourceService)Application.getBootLoader().getBootable(PluginSourceService.class);
                source = sources.getDefault();
                Logger.info((String)("no plugin source given, using default: " + source.getName()));
            }
            if (!source.canWrite()) {
                throw new ApplicationException(i18n.tr("Plugin-Ordner \"{0}\" nicht beschreibbar"));
            }
            File zip = plugin.getFile();
            File pluginDir = source.getDir();
            File target = new File(pluginDir, plugin.getName());
            if (target.exists()) {
                monitor.setStatusText(i18n.tr("L\u00f6sche vorherige Version..."));
                Logger.info((String)("deleting previous version in " + target));
                File marker = new File(target, ".deletemarker");
                if (marker.exists()) {
                    throw new ApplicationException(i18n.tr("Bitte starten Sie erst Jameica neu."));
                }
                if (!FileUtil.deleteRecursive((File)target)) {
                    throw new ApplicationException(i18n.tr("Der Ordner {0} konnte nicht gel\u00f6scht werden.", target.getAbsolutePath()));
                }
            }
            monitor.setStatusText(i18n.tr("Installiere..."));
            Logger.info((String)("extracting " + zip + " to " + target));
            ZipExtractor extractor = new ZipExtractor(new ZipFile(zip, 1));
            extractor.setMonitor(monitor);
            extractor.extract(pluginDir);
            if (!multi) {
                monitor.setStatus(4);
                monitor.setStatusText(i18n.tr("Plugin installiert, bitte starten Sie Jameica neu"));
            }
            Logger.info((String)"plugin successfully deployed");
            Manifest manifest = new Manifest(new File(target, "plugin.xml"));
            manifest.setPluginSource(source.getType());
            Application.getMessagingFactory().sendMessage(new PluginMessage(manifest, PluginMessage.Event.INSTALLED));
            if (!multi) {
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Plugin installiert, bitte starten Sie Jameica neu"), 0));
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (!(e instanceof ApplicationException)) {
                Logger.error((String)"unable to install plugin", (Throwable)e);
                msg = i18n.tr("Fehler beim Installieren: {0}", msg);
            }
            monitor.setStatus(3);
            monitor.setStatusText(msg);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(msg, 1));
        }
    }

    public void shutdown() {
    }

    private void cleanup(PluginSource source) {
        File dir = source.getDir();
        try {
            File[] pluginDirs;
            Logger.info((String)("  " + dir));
            SecurityManagerService s = (SecurityManagerService)Application.getBootLoader().getBootable(SecurityManagerService.class);
            for (final File pluginDir : pluginDirs = new FileFinder(dir).findAll()) {
                if (!pluginDir.canRead() || !pluginDir.isDirectory()) {
                    Logger.warn((String)("  skipping " + pluginDir.getAbsolutePath() + " - no directory or not readable"));
                    continue;
                }
                File marker = new File(pluginDir, ".deletemarker");
                if (!marker.exists() || !marker.isFile()) continue;
                Logger.info((String)("  clean up " + pluginDir));
                s.getSecurityManager().doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            if (!FileUtil.deleteRecursive((File)pluginDir)) {
                                throw new IOException("unable to delete " + pluginDir);
                            }
                        }
                        catch (Exception e) {
                            Logger.error((String)("unable to cleanup uninstalled plugin in " + pluginDir));
                        }
                        return null;
                    }

                    public String toString() {
                        return "delete " + pluginDir;
                    }
                });
            }
        }
        catch (Exception e) {
            Logger.error((String)("unable to cleanup " + dir), (Throwable)e);
        }
    }
}

