/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.io.FileFinder;
import de.willuhn.jameica.plugin.Dependency;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.MultipleClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public class ClassService
implements Bootable {
    public Class[] depends() {
        return new Class[]{LogService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        try {
            this.prepareClasses(Application.getManifest(), Application.getClassLoader());
            Object[] jars = Application.getClassLoader().addJars(new File("lib"));
            if (jars != null) {
                Arrays.sort(jars);
                for (int i = 0; i < jars.length; ++i) {
                    Logger.info((String)("loaded system jar " + ((File)jars[i]).getAbsolutePath()));
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
    }

    public synchronized MultipleClassLoader prepareClasses(Manifest manifest) throws Exception {
        if (manifest == null) {
            throw new Exception("no manifest given");
        }
        File dir = new File(manifest.getPluginDir());
        Logger.info((String)("checking directory " + dir.getAbsolutePath()));
        Application.getCallback().getStartupMonitor().setStatusText("checking directory " + dir.getAbsolutePath());
        Application.getCallback().getStartupMonitor().addPercentComplete(2);
        MultipleClassLoader mycl = null;
        if (manifest.isShared()) {
            Logger.info((String)("using global classloader for plugin " + manifest.getName()));
            mycl = Application.getClassLoader();
        } else {
            Logger.info((String)("using private classloader for plugin " + manifest.getName()));
            mycl = new MultipleClassLoader();
            mycl.setName("loader." + manifest.getName());
            Logger.info((String)"  adding system classloader");
            mycl.addClassloader((ClassLoader)Application.getClassLoader());
            Dependency[] deps = manifest.getDirectDependencies();
            if (deps != null && deps.length > 0) {
                Logger.info((String)"  adding depending classloaders");
                List<Manifest> plugins = Application.getPluginLoader().getInstalledManifests();
                block0: for (int i = 0; i < plugins.size(); ++i) {
                    Manifest mf = plugins.get(i);
                    if (mf == null || manifest.getName().equals(mf.getName())) continue;
                    for (int k = 0; k < deps.length; ++k) {
                        if (!((Dependency)deps[k]).getName().equals(mf.getName()) || !mf.isLoaded()) continue;
                        Logger.info((String)("    " + mf.getName()));
                        mycl.addClassloader((ClassLoader)mf.getClassLoader());
                        continue block0;
                    }
                }
            }
        }
        mycl.add(dir);
        for (File bin : Arrays.asList(new File(dir, "bin"), new File(dir, "target/classes"))) {
            if (bin.exists()) {
                Logger.info((String)(mycl.getName() + ": added dir " + bin));
                mycl.add(bin);
            }
            Application.getCallback().getStartupMonitor().addPercentComplete(2);
        }
        Object[] jars = mycl.addJars(dir);
        if (jars != null) {
            Arrays.sort(jars);
            for (int i = 0; i < jars.length; ++i) {
                Logger.info((String)(mycl.getName() + ": loaded jar " + ((File)jars[i]).getAbsolutePath()));
            }
        }
        Application.getCallback().getStartupMonitor().addPercentComplete(1);
        this.prepareClasses(manifest, mycl);
        return mycl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareClasses(Manifest manifest, MultipleClassLoader mycl) throws IOException {
        long count = 0L;
        File dir = new File(manifest.getPluginDir());
        FileFinder ff = new FileFinder(dir);
        String[] cfIncludes = manifest.getClassFinderIncludes();
        if (cfIncludes.length == 0) {
            Logger.info((String)"no classfinder includes for this plugin");
            return;
        }
        for (int i = 0; i < cfIncludes.length; ++i) {
            Logger.debug((String)("classfinder include: " + cfIncludes[i]));
            ff.matches(cfIncludes[i]);
        }
        File[] child = ff.findRecursive();
        String path = dir.getCanonicalPath();
        path = path.replaceAll("\\\\", "/");
        Pattern binDir1 = Pattern.compile(path + "/bin/.*\\.class");
        Pattern binDir2 = Pattern.compile(path + "/target/classes.*\\.class");
        for (int i = 0; i < child.length; ++i) {
            if (++count % 75L == 0L) {
                Application.getCallback().getStartupMonitor().addPercentComplete(1);
            }
            String name = child[i].getCanonicalPath();
            boolean binDir = binDir1.matcher(name = name.replaceAll("\\\\", "/")).matches();
            if (binDir || binDir2.matcher(name).matches()) {
                name = name.substring(path.length() + (binDir ? 5 : 16));
                if ((name = name.substring(0, name.indexOf(".class")).replace('/', '.')).startsWith(".")) {
                    name = name.substring(1);
                }
                ClassService.load(mycl, name);
            }
            if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
            Logger.info((String)("inspecting " + name));
            ZipFile jar = null;
            try {
                jar = new JarFile(child[i]);
            }
            catch (IOException ioe) {
                Logger.error((String)("unable to load " + name + ", skipping"), (Throwable)ioe);
                if (jar == null) continue;
                try {
                    jar.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close jar file", (Throwable)e);
                }
                continue;
            }
            try {
                Enumeration<JarEntry> jarEntries = ((JarFile)jar).entries();
                JarEntry entry = null;
                while (jarEntries.hasMoreElements()) {
                    String entryName;
                    int idxClass;
                    if (++count % 75L == 0L) {
                        Application.getCallback().getStartupMonitor().addPercentComplete(1);
                    }
                    if ((idxClass = (entryName = (entry = jarEntries.nextElement()).getName()).indexOf(".class")) == -1) continue;
                    entryName = entryName.substring(0, idxClass).replace('/', '.').replace('\\', '.');
                    ClassService.load(mycl, entryName);
                }
                continue;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to close jar file", (Throwable)e);
                    }
                }
            }
        }
    }

    private static void load(MultipleClassLoader cl, String classname) {
        try {
            cl.load(classname);
        }
        catch (Throwable t) {
            Logger.error((String)("error while loading class " + classname), (Throwable)t);
        }
    }
}

