/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.annotation.Inject;
import de.willuhn.annotation.Injector;
import de.willuhn.annotation.Lifecycle;
import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.services.inject.InjectHandler;
import de.willuhn.jameica.services.inject.InjectHandlerPostConstruct;
import de.willuhn.jameica.services.inject.InjectHandlerReceive;
import de.willuhn.jameica.services.inject.InjectHandlerResource;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.JameicaException;
import de.willuhn.logging.Logger;
import de.willuhn.util.Session;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.PreDestroy;

public class BeanService
implements Bootable {
    private List<InjectHandler> injectHandlers = new LinkedList<InjectHandler>();
    private Map<Class, Object> contextScope = new HashMap<Class, Object>();
    private Stack contextOrder = new Stack();
    private Session sessionScope = new Session();

    public Class<Bootable>[] depends() {
        return new Class[]{LogService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        this.injectHandlers.clear();
        this.injectHandlers.add(new InjectHandlerResource());
        this.injectHandlers.add(new InjectHandlerPostConstruct());
        this.injectHandlers.add(new InjectHandlerReceive());
    }

    public void addInjectHandler(InjectHandler handler) {
        this.injectHandlers.add(handler);
    }

    public <T> T get(Class<T> type) {
        if (type == null) {
            return null;
        }
        String name = type.getSimpleName();
        Logger.trace((String)("searching for bean " + name));
        Object bean = null;
        bean = this.contextScope.get(type);
        if (bean != null) {
            Logger.trace((String)"  found in context scope");
            return (T)bean;
        }
        bean = this.sessionScope.get(type);
        if (bean != null) {
            Logger.trace((String)"  found in session scope");
            return (T)bean;
        }
        try {
            Lifecycle.Type lct;
            Logger.debug((String)("  creating new " + type));
            bean = type.newInstance();
            Lifecycle lc = type.getAnnotation(Lifecycle.class);
            Lifecycle.Type type2 = lct = lc != null ? lc.value() : null;
            if (lct == null) {
                Logger.trace((String)"  no lifecycle -> request scope");
            } else if (lct == Lifecycle.Type.REQUEST) {
                Logger.trace((String)"  request scope");
            } else if (lct == Lifecycle.Type.CONTEXT) {
                Logger.trace((String)"  context scope");
                this.contextScope.put(type, bean);
                this.contextOrder.add(bean);
            } else if (lct == Lifecycle.Type.SESSION) {
                Logger.trace((String)"  session scope");
                this.sessionScope.put(type, bean);
            } else {
                Logger.trace((String)"  unknown scope");
            }
            this.inject(bean);
            return (T)bean;
        }
        catch (JameicaException je) {
            throw je;
        }
        catch (Throwable t) {
            Logger.error((String)("unable to create instance of " + type), (Throwable)t);
            throw new JameicaException(Application.getI18n().tr("{0} kann nicht erstellt werden: {1}", new String[]{type.getSimpleName(), t.getMessage()}));
        }
    }

    public void inject(Object bean) throws JameicaException {
        String name = bean.getClass().getSimpleName();
        try {
            for (InjectHandler handler : this.injectHandlers) {
                handler.inject(bean);
            }
        }
        catch (JameicaException je) {
            throw je;
        }
        catch (Exception e) {
            Logger.error((String)("unable to inject dependencies into " + name), (Throwable)e);
            throw new JameicaException(Application.getI18n().tr("Abh\u00e4ngigkeiten k\u00f6nnen nicht in {0} injiziert werden: {1}", new String[]{name, e.getMessage()}));
        }
    }

    public void shutdown() {
        try {
            Logger.trace((String)"invoking predestroy for context beans");
            while (!this.contextOrder.isEmpty()) {
                Object bean = this.contextOrder.pop();
                try {
                    Inject.inject(bean, (Injector)new Injector(){

                        public void inject(Object bean, AccessibleObject field, Annotation annotation) throws Exception {
                            Method m = (Method)field;
                            Logger.trace((String)("  " + bean.getClass().getSimpleName() + "." + m.getName()));
                            m.setAccessible(true);
                            m.invoke(bean, (Object[])null);
                        }
                    }, (Class[])new Class[]{PreDestroy.class});
                }
                catch (Exception e) {
                    Logger.error((String)("unable to predestroy " + bean.getClass().getSimpleName()), (Throwable)e);
                }
            }
        }
        finally {
            this.contextOrder.clear();
            this.contextScope.clear();
            this.sessionScope.clear();
            this.injectHandlers.clear();
        }
    }
}

