/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.backup.BackupEngine;
import de.willuhn.jameica.backup.BackupFile;
import de.willuhn.jameica.messaging.BootMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.services.LogService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BackupService
implements Bootable {
    private static final Settings settings = new Settings(BackupService.class);
    private Consumer mc = new Consumer();

    public Class[] depends() {
        return new Class[]{LogService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        Application.getMessagingFactory().getMessagingQueue("jameica.error").registerMessageConsumer(this.mc);
        try {
            BackupFile file = BackupEngine.getCurrentRestore();
            if (file == null) {
                return;
            }
            BackupEngine.doRestore(loader.getMonitor());
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage(new BootMessage(Application.getI18n().tr("Fehler beim Wiederherstellen des Backups: {0}", ae.getMessage())));
        }
        catch (Exception e) {
            Logger.error((String)"unable to restore backup", (Throwable)e);
            Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage(new BootMessage(Application.getI18n().tr("Fehler beim Wiederherstellen des Backups. Bitte pr\u00fcfen Sie das System-Log")));
        }
    }

    public List<String> getLastErrors() {
        return Arrays.asList(settings.getList("errors", new String[0]));
    }

    public void shutdown() {
        try {
            settings.setAttribute("errors", this.mc.errors.toArray(new String[0]));
            if (this.mc.errors.size() > 0) {
                String text = this.mc.errors.size() + " error(s) occured in current jameica session, skipping backup";
                Application.getCallback().getShutdownMonitor().setStatusText(text);
                Logger.warn((String)("**** " + text));
                return;
            }
            BackupEngine.doBackup(Application.getCallback().getShutdownMonitor(), true);
        }
        catch (ApplicationException e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
        }
        finally {
            Application.getMessagingFactory().getMessagingQueue("jameica.error").unRegisterMessageConsumer(this.mc);
        }
    }

    private class Consumer
    implements MessageConsumer {
        private List<String> errors = new ArrayList<String>();

        private Consumer() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            if (this.errors.size() == 50) {
                Logger.error((String)"reached max error count (50), further errors will not be stored");
                return;
            }
            Object data = ((QueryMessage)message).getData();
            String text = data != null ? data.toString() : "<unknown>";
            Logger.warn((String)("detected error: " + text));
            if (data instanceof Exception) {
                text = ((Exception)data).getMessage();
            }
            this.errors.add(text);
        }
    }
}

