/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security.crypto;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.security.Wallet;
import de.willuhn.jameica.security.crypto.Engine;
import de.willuhn.jameica.security.crypto.RSAEngine;
import de.willuhn.logging.Logger;
import de.willuhn.util.Base64;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.apache.commons.lang.RandomStringUtils;

public abstract class AbstractPasswordBasedEngine
implements Engine {
    private Wallet wallet = null;

    @Override
    public void encrypt(InputStream is, OutputStream os) throws Exception {
        OutputStream cos = this.encrypt(os);
        IOUtil.copy((InputStream)is, (OutputStream)cos);
        cos.close();
    }

    @Override
    public void decrypt(InputStream is, OutputStream os) throws Exception {
        InputStream cis = this.decrypt(is);
        IOUtil.copy((InputStream)cis, (OutputStream)os);
    }

    @Override
    public OutputStream encrypt(OutputStream os) throws Exception {
        Logger.debug((String)("encrypting data using " + this.getAlgorithm()));
        Cipher cipher = this.createCipher(1);
        return new CipherOutputStream(os, cipher);
    }

    @Override
    public InputStream decrypt(InputStream is) throws Exception {
        Logger.debug((String)("decrypting data using " + this.getAlgorithm()));
        Cipher cipher = this.createCipher(2);
        return new CipherInputStream(is, cipher);
    }

    private Cipher createCipher(int mode) throws Exception {
        Logger.debug((String)"creating cipher");
        Cipher cipher = Cipher.getInstance(this.getAlgorithm());
        AlgorithmParameterSpec spec = this.getParameterSpec();
        if (spec != null) {
            cipher.init(mode, this.getKey(), spec);
        } else {
            cipher.init(mode, this.getKey());
        }
        return cipher;
    }

    private synchronized Wallet getWallet() throws Exception {
        if (this.wallet == null) {
            this.wallet = new Wallet(this.getClass(), new RSAEngine());
        }
        return this.wallet;
    }

    byte[] getSalt(int len) throws Exception {
        if (len < 1) {
            throw new Exception("invalid salt length: " + len);
        }
        Wallet wallet = this.getWallet();
        String s = (String)((Object)wallet.get("salt"));
        if (s == null) {
            s = (String)((Object)wallet.get("salt." + len));
        }
        if (s != null) {
            return Base64.decode((String)s);
        }
        Logger.debug((String)"creating new salt");
        byte[] salt = new byte[len];
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.nextBytes(salt);
        wallet.set("salt." + len, (Serializable)((Object)Base64.encode((byte[])salt)));
        return salt;
    }

    char[] getPassword(int len) throws Exception {
        if (len < 1) {
            throw new Exception("invalid password length: " + len);
        }
        Wallet wallet = this.getWallet();
        String s = (String)((Object)wallet.get("password"));
        if (s == null) {
            s = (String)((Object)wallet.get("password." + len));
        }
        if (s != null) {
            return s.toCharArray();
        }
        s = RandomStringUtils.randomAscii((int)len);
        Logger.debug((String)("created random password, length: " + s.length()));
        wallet.set("password." + len, (Serializable)((Object)s));
        return s.toCharArray();
    }

    abstract AlgorithmParameterSpec getParameterSpec() throws Exception;

    abstract String getAlgorithm();

    abstract Key getKey() throws Exception;
}

