/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security;

import de.willuhn.jameica.security.crypto.Engine;
import de.willuhn.jameica.security.crypto.RSAEngine;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Wallet {
    private Class clazz = null;
    private Hashtable<String, Serializable> serialized = new Hashtable();
    private Engine engine = new RSAEngine();

    public Wallet(Class clazz) throws Exception {
        this(clazz, null);
    }

    public Wallet(Class clazz, Engine engine) throws Exception {
        this.clazz = clazz;
        this.setEngine(engine);
        Logger.debug((String)("creating wallet " + clazz.getName() + " via " + this.engine.getClass().getSimpleName()));
        this.read();
    }

    public void setEngine(Engine engine) {
        if (engine != null) {
            this.engine = engine;
        }
    }

    public void set(String alias, Serializable data) throws Exception {
        if (alias == null) {
            Logger.warn((String)"alias cannot be null");
            return;
        }
        if (data == null) {
            Logger.debug((String)("removing key " + alias));
            this.serialized.remove(alias);
        } else {
            Logger.debug((String)("storing key " + alias));
            this.serialized.put(alias, data);
        }
        this.write();
    }

    public Serializable delete(String alias) throws Exception {
        if (alias == null) {
            Logger.warn((String)"alias cannot be null");
            return null;
        }
        Logger.debug((String)("removing key " + alias));
        Serializable s = this.serialized.remove(alias);
        this.write();
        return s;
    }

    public synchronized void deleteAll(String aliasPrefix) throws Exception {
        if (aliasPrefix == null || aliasPrefix.length() == 0) {
            this.serialized.clear();
        } else {
            Enumeration<String> e = this.serialized.keys();
            String s = null;
            while (e.hasMoreElements()) {
                s = e.nextElement();
                if (s == null || !s.startsWith(aliasPrefix)) continue;
                Logger.debug((String)("removing key " + s));
                this.serialized.remove(s);
            }
        }
        this.write();
    }

    public synchronized String[] getAll(String aliasPrefix) throws Exception {
        ArrayList<String> keys = new ArrayList<String>();
        Enumeration<String> e = this.serialized.keys();
        String s = null;
        while (e.hasMoreElements()) {
            s = e.nextElement();
            if (s == null || aliasPrefix != null && !s.startsWith(aliasPrefix)) continue;
            Logger.debug((String)("retrieving key " + s));
            keys.add(s);
        }
        return keys.toArray(new String[keys.size()]);
    }

    public Enumeration<String> getKeys() {
        return this.serialized.keys();
    }

    public Serializable get(String alias) {
        if (alias == null) {
            Logger.warn((String)"alias cannot be null");
            return null;
        }
        Logger.debug((String)("reading key " + alias));
        return this.serialized.get(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void read() throws Exception {
        Hashtable<String, Serializable> hashtable = this.serialized;
        synchronized (hashtable) {
            this.read(this.getFilename());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void read(String file) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            this.serialized = new Hashtable();
            return;
        }
        InputStream is = null;
        Logger.debug((String)("reading wallet file " + f.getAbsolutePath() + " via " + this.engine.getClass().getSimpleName()));
        try {
            is = new BufferedInputStream(new FileInputStream(f));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.engine.decrypt(is, bos);
            Logger.debug((String)"deserializing wallet");
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            XMLDecoder xml = new XMLDecoder(bis);
            this.serialized = (Hashtable)xml.readObject();
            xml.close();
            Logger.debug((String)"reading wallet done");
            return;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to close file", (Throwable)e);
            }
        }
    }

    private String getFilename() {
        return Application.getConfig().getConfigDir() + "/" + this.clazz.getName() + ".wallet2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void write() throws Exception {
        Hashtable<String, Serializable> hashtable = this.serialized;
        synchronized (hashtable) {
            File file = new File(this.getFilename());
            if (this.serialized.size() == 0 && file.exists()) {
                Logger.info((String)("deleting wallet file " + this.getFilename()));
                if (file.delete()) {
                    Logger.debug((String)"wallet deleted");
                }
                return;
            }
            Logger.debug((String)("writing wallet file " + this.getFilename() + " via " + this.engine.getClass().getSimpleName()));
            File directory = file.getAbsoluteFile().getParentFile();
            String prefix = file.getName() + "_";
            File tempfile = File.createTempFile(prefix, "", directory);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Logger.debug((String)"serializing wallet");
            XMLEncoder xml = new XMLEncoder(bos);
            xml.writeObject(this.serialized);
            xml.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tempfile));
            this.engine.encrypt(bis, os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            Logger.debug((String)"test if readable");
            if (!tempfile.exists()) {
                throw new IOException("unable to save wallet file");
            }
            this.read(tempfile.getAbsolutePath());
            Logger.debug((String)"renaming temp file");
            file.delete();
            tempfile.renameTo(file);
            Logger.debug((String)"writing wallet done");
        }
    }
}

