/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security;

import de.willuhn.jameica.messaging.KeystoreChangedMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.security.SSLRMIFailureHandler;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLRMISocketFactory
extends RMISocketFactory {
    private SSLServerSocketFactory serverSocketFactory;
    private SSLSocketFactory socketFactory;

    public SSLRMISocketFactory() throws Exception {
        RMISocketFactory.setFailureHandler(new SSLRMIFailureHandler());
        this.init();
        Application.getMessagingFactory().registerMessageConsumer(new MessageConsumer(){

            @Override
            public void handleMessage(Message message) throws Exception {
                SSLRMISocketFactory.this.init();
            }

            @Override
            public Class[] getExpectedMessageTypes() {
                return new Class[]{KeystoreChangedMessage.class};
            }

            @Override
            public boolean autoRegister() {
                return false;
            }
        });
    }

    private synchronized void init() throws Exception {
        Logger.info((String)"(re)init \"rmi over ssl\" socket factory");
        SSLContext context = Application.getSSLFactory().getSSLContext();
        this.serverSocketFactory = context.getServerSocketFactory();
        this.socketFactory = context.getSocketFactory();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Logger.debug((String)("Creating client socket to " + host + ":" + port));
        SSLSocket socket = (SSLSocket)this.socketFactory.createSocket(host, port);
        this.log(socket);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        Logger.info((String)("Creating server socket at port " + port + "/tcp"));
        SSLServerSocket socket = (SSLServerSocket)this.serverSocketFactory.createServerSocket(port);
        this.log(socket);
        boolean clientAuth = Application.getConfig().getRmiUseClientAuth();
        Logger.info((String)("Client Auth: " + clientAuth));
        socket.setWantClientAuth(clientAuth);
        socket.setNeedClientAuth(clientAuth);
        return socket;
    }

    private void log(Object socket) throws IOException {
        int i;
        String[] cipher;
        String[] protos;
        Closeable s;
        if (!Logger.isLogging((Level)Level.DEBUG)) {
            return;
        }
        String socketType = "CLIENT";
        if (socket instanceof SSLServerSocket) {
            socketType = "SERVER";
            s = (SSLServerSocket)socket;
            protos = ((SSLServerSocket)s).getEnabledProtocols();
            cipher = ((SSLServerSocket)s).getEnabledCipherSuites();
            Logger.debug((String)(socketType + " Socket receive buffer size: " + ((ServerSocket)s).getReceiveBufferSize()));
        } else {
            s = (SSLSocket)socket;
            protos = ((SSLSocket)s).getEnabledProtocols();
            cipher = ((SSLSocket)s).getEnabledCipherSuites();
            Logger.debug((String)(socketType + " Socket receive buffer size: " + ((Socket)s).getReceiveBufferSize()));
        }
        StringBuffer sb = new StringBuffer("enabled protocols for " + socketType + " socket: ");
        for (i = 0; i < protos.length; ++i) {
            sb.append(protos[i]);
            sb.append(" ");
        }
        Logger.debug((String)sb.toString());
        sb = new StringBuffer("enabled cipher suites for " + socketType + " socket: ");
        for (i = 0; i < cipher.length; ++i) {
            sb.append(cipher[i]);
            sb.append(" ");
        }
        Logger.debug((String)sb.toString());
    }
}

