/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security;

import de.willuhn.io.FileFinder;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.messaging.KeystoreChangedMessage;
import de.willuhn.jameica.security.JameicaTrustManager;
import de.willuhn.jameica.security.LoginVerifier;
import de.willuhn.jameica.security.crypto.RSAEngine;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.ApplicationCallback;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class SSLFactory {
    private static final Settings settings = new Settings(SSLFactory.class);
    private static final String SYSTEM_ALIAS = "jameica";
    private static final String CERT_UPDATES = "-----BEGIN CERTIFICATE-----\nMIIDdjCCAt+gAwIBAgIBTTANBgkqhkiG9w0BAQUFADCBqTELMAkGA1UEBhMCREUx\nDzANBgNVBAgTBlNheG9ueTEQMA4GA1UEBxMHTGVpcHppZzEkMCIGA1UEChQbd2ls\nbHVobiBzb2Z0d2FyZSAmIHNlcnZpY2VzMRIwEAYDVQQLEwlMaWNlbnNpbmcxHTAb\nBgNVBAMTFHdpbGx1aG4uY2EubGljZW5zaW5nMR4wHAYJKoZIhvcNAQkBFg9pbmZv\nQHdpbGx1aG4uZGUwHhcNMTMwODA5MjAzMzEyWhcNMTYwNTA1MjAzMzEyWjCBqTEL\nMAkGA1UEBhMCREUxDzANBgNVBAgTBlNheG9ueTEQMA4GA1UEBxMHTGVpcHppZzEk\nMCIGA1UEChQbd2lsbHVobiBzb2Z0d2FyZSAmIHNlcnZpY2VzMRgwFgYDVQQLEw9K\nYW1laWNhLVVwZGF0ZXMxFzAVBgNVBAMTDmphbWVpY2EudXBkYXRlMR4wHAYJKoZI\nhvcNAQkBFg9pbmZvQHdpbGx1aG4uZGUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJ\nAoGBALhRYGFQHnN/5hxYPNJktKNOkzh++lH6KqCl/ReyTqXPj4DwZPHs04+i/yiE\nK7E9XnWO3G0MN4pdMGcRqKwh1p+nSKBfzYJOhYjnR6YkFNMMztX2ptJTqzNm+9Dk\naJuHPaOoV1CZG5ZoXhzwfi4+N468u9KqnJaEVnlKKsnOLCUDAgMBAAGjgaswgagw\nGgYDVR0RBBMwEYEPaW5mb0B3aWxsdWhuLmRlMAwGA1UdEwQFMAMCAQAwRwYJYIZI\nAYb4QgENBDoWOGN1c3RvbSBzZXJ2ZXIgY2VydGlmaWNhdGUgYnkgd2lsbHVobiBz\nb2Z0d2FyZSAmIHNlcnZpY2VzMBEGCWCGSAGG+EIBAQQEAwIGQDAgBgNVHSUEGTAX\nBgorBgEEAYI3CgMDBglghkgBhvhCBAEwDQYJKoZIhvcNAQEFBQADgYEAHekUpx6R\nwk3qlS2bIa5W6YYu2JvTeJ5lzQEIetIehxFiqAtphRrZ5/D1bNPU+Q7bc+5o6c6Q\n9UtAQiKKX/RmlQZLAauKXoyryCvpjrTX+NRrMBjrV9NWfFgm8L8FrzIT6SaCsEn/\nslSjwfp3thRCvIoZe6jM95auQDGm4DRtwCk=\n-----END CERTIFICATE-----\n";
    private static final String CERT_JAMEICA_UPDATE_CA = "-----BEGIN CERTIFICATE-----\nMIIDtjCCAp6gAwIBAgIIQdBXw3pRkF8wDQYJKoZIhvcNAQELBQAwTzETMBEGA1UE\nAwwKSmFtZWljYSBDQTEVMBMGA1UECgwMT2xhZiBXaWxsdWhuMRQwEgYDVQQLDAtq\nYW1laWNhLm9yZzELMAkGA1UEBhMCREUwHhcNMTYwMzE2MjMwMDAwWhcNMzYwMzE2\nMjMwMDAwWjBYMRwwGgYDVQQDDBNKYW1laWNhIFVwZGF0ZSBDQSAxMRUwEwYDVQQK\nDAxPbGFmIFdpbGx1aG4xFDASBgNVBAsMC2phbWVpY2Eub3JnMQswCQYDVQQGEwJE\nRTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALpjmkRam57evKzQKmIW\n0nUTns3SdqHuLDyNwS60JJJclxPOU3UylmXtcnPtK4DhkavCdU490yl++zHctVrG\nH8XBVMgIxZCprhlWRVFzfP6jnKFFpOD34ZCNMBhOeQ7Hz9mgI63QIYU3nVg3gajT\nt2X+f5FpXczKdjXRKuI0FZEE35q37kNXbUXp7nL1M99BK2yo+x8E7JBvzk6DkZfp\nPxZ31B3tuZhw99chNAQl764bLqMSsXzQQHAxJYUOrulFiHvISQmbqFryXW4LcYL+\n5Uc1qKMPMop86SlDIyH3IvSZLccJXq8flndd1hhf8mNjXb3+e1/dDRF6uw+dukeL\nr/cCAwEAAaOBjDCBiTAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBtjAT\nBgNVHSUEDDAKBggrBgEFBQcDATARBglghkgBhvhCAQEEBAMCAgQwHQYDVR0OBBYE\nFAxj0e2bVgGLUO63o6XwnNhmM9TbMB8GA1UdIwQYMBaAFPdfpjhnPl0DIx1ACh9P\n3EzUD75OMA0GCSqGSIb3DQEBCwUAA4IBAQBEJiPd2qCronyUokMRsY/6jK7K6be9\nLVyySybQf5jY4lvg0Fd3yHhVqPm/fVDjs6GYZGTop3w6uNGhBnWslspj37GgCQOS\nhca9eRAx7bHMc7rUGRVdCb3xvi9lZGQ563N55y0uoAmtdGca6ZKAJnouTjPbRfpY\nTnJuB3P0zKzKE4xUO5gudP1RtC0fw55GiEOsKMFekeOaJ6RvffycyMNxeSw+cOW1\nRulwCIbnHPpWQf25fpmKxOnxKm2gvkjnP25rDz1W4NpdY1rmajj5bjrztnOGeg9J\n98Lsboil4S42+SjPDdcT2Kucg9lc9SsMRYq/WTs2Oiu5IeI+1ErBC4Gl\n-----END CERTIFICATE-----\n";
    private static final String CERT_JAMEICA_CA = "-----BEGIN CERTIFICATE-----\nMIIDijCCAnKgAwIBAgIIIDT28rTyXw4wDQYJKoZIhvcNAQELBQAwTzETMBEGA1UE\nAwwKSmFtZWljYSBDQTEVMBMGA1UECgwMT2xhZiBXaWxsdWhuMRQwEgYDVQQLDAtq\nYW1laWNhLm9yZzELMAkGA1UEBhMCREUwHhcNMTYwMzE2MjMwMDAwWhcNMzYwMzE2\nMjMwMDAwWjBPMRMwEQYDVQQDDApKYW1laWNhIENBMRUwEwYDVQQKDAxPbGFmIFdp\nbGx1aG4xFDASBgNVBAsMC2phbWVpY2Eub3JnMQswCQYDVQQGEwJERTCCASIwDQYJ\nKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIxhMB2ORGh/H8Xfh7Kc0DElRo9JJgl0\nTO2TDOqBm6Bfy9822PthZ55Xs4hxCFjL9FIcAzlvNvHRaHEVbphUN/nI2jbeez+v\neKU17U2O08V0qYymCgVFH2TpGzsJzmdq/XbXrP3wueaiJHni/BToMXLyUFggoVT2\n7lLDL5wgWDWezRCv9aQF5KfOuVSmBxRzF6PvePnHqAMlLXhBNehaq6UD1Kt2C+8X\ndeENXpixXagLCehSp9DaF4yAlnnvmKct7pRLCMIBqMVINY+yH64HQFbX2f8ehwgY\nQe8FgioOsp1GgrNRv376VYDaNMXGTPDwNKiGEK1Fo9PhtMx6+90wxA8CAwEAAaNq\nMGgwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAbYwEwYDVR0lBAwwCgYI\nKwYBBQUHAwEwEQYJYIZIAYb4QgEBBAQDAgIEMB0GA1UdDgQWBBT3X6Y4Zz5dAyMd\nQAofT9xM1A++TjANBgkqhkiG9w0BAQsFAAOCAQEAcrvxrbeLxa8iKlc/YoiVZbA/\nvj66K8Oipxq5I+WJDU+mUt1hC7QnRq74Tc8wwfJBH2DY+7IVk5Bv1wn51JEPaxI9\nKMg8O5dvl8phJGPTNlpjtuJtr/1mSfxbdzc07eIQYs/mZMlpLDazcXC1Q6fxclGh\n0XSnl3Ka1Qz3nS6qCFI4BuyA42RXo3YO7BfVCyoZKWg4J6OktoGw1cA+UhTSDgAl\nTLHvbP2BUKmbyKSvSQc5sYPHZ+WadMSvPMdpgiXUTZQMbK+I9UkZG7BiZlVIHbAc\nF4wFaeMMLiRmc6zT3wjquwMVzyeVlm7NUTcjQfVYz3fs+kaZa3p0q597clshAw==\n-----END CERTIFICATE-----\n";
    private CertificateFactory factory = null;
    private File keystoreFile = null;
    private KeyStore keystore = null;
    private X509Certificate certificate = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private SSLContext sslContext = null;
    private ApplicationCallback callback = Application.getCallback();
    private JameicaTrustManager trustmanager = null;

    public synchronized void init() throws Exception {
        Logger.info((String)"init encryption system");
        Application.getCallback().getStartupMonitor().setStatusText("init encryption system");
        File keyStoreFile = this.getKeyStoreFile();
        if (keyStoreFile.exists() && keyStoreFile.canRead() && keyStoreFile.length() > 0L) {
            this.getSystemCertificate();
            return;
        }
        Application.getCallback().getStartupMonitor().addPercentComplete(10);
        Logger.info((String)"no certificates found, creating...");
        Application.getCallback().getStartupMonitor().setStatusText("generating new keys and certificates");
        Logger.info((String)"  generating rsa keypair");
        KeyPairGenerator kp = KeyPairGenerator.getInstance("RSA", "BC");
        kp.initialize(2048);
        KeyPair keypair = kp.generateKeyPair();
        this.privateKey = keypair.getPrivate();
        this.publicKey = keypair.getPublic();
        Application.getCallback().getStartupMonitor().addPercentComplete(10);
        Logger.info((String)"  generating selfsigned x.509 certificate");
        String hostname = Application.getCallback().getHostname();
        Logger.info((String)("  using hostname: " + hostname));
        X500NameBuilder nameBuilder = new X500NameBuilder();
        nameBuilder.addRDN(BCStyle.CN, hostname);
        nameBuilder.addRDN(BCStyle.O, "Jameica Certificate");
        String username = System.getProperty("user.name");
        if (username != null && username.length() > 0) {
            String prefix = "";
            if (Application.inClientMode()) {
                prefix = "client.";
            } else if (Application.inServerMode()) {
                prefix = "server.";
            }
            nameBuilder.addRDN(BCStyle.GIVENNAME, prefix + username);
            nameBuilder.addRDN(BCStyle.OU, prefix + username);
        }
        X500Name user = nameBuilder.build();
        byte[] serno = new byte[8];
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.nextBytes(serno);
        BigInteger serial = new BigInteger(serno).abs();
        Date notBefore = new Date();
        Date notAfter = new Date(System.currentTimeMillis() + 630720000000L);
        JcaX509v3CertificateBuilder generator = new JcaX509v3CertificateBuilder(user, serial, notBefore, notAfter, user, this.getPublicKey());
        generator.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        generator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(254));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(this.getPrivateKey());
        X509CertificateHolder holder = generator.build(signer);
        this.certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(holder);
        Logger.info((String)"  creating keystore");
        this.keystore = KeyStore.getInstance("JKS");
        char[] pw = this.callback.createPassword().toCharArray();
        this.keystore.load(null, pw);
        Logger.info((String)"  saving system certificate");
        this.keystore.setKeyEntry(SYSTEM_ALIAS, this.privateKey, pw, new X509Certificate[]{this.certificate});
        this.storeKeystore();
        Application.getCallback().getStartupMonitor().addPercentComplete(10);
    }

    public synchronized void changePassword() throws Exception {
        Logger.warn((String)"starting password change for keystore");
        Logger.warn((String)"  reading private key");
        PrivateKey k = this.getPrivateKey();
        X509Certificate cert = this.getSystemCertificate();
        this.certificate = null;
        this.privateKey = null;
        this.publicKey = null;
        Logger.warn((String)"  starting password change dialog");
        this.callback.changePassword();
        Logger.warn((String)"  changing password of private key");
        this.keystore.setKeyEntry(SYSTEM_ALIAS, k, this.callback.getPassword().toCharArray(), new X509Certificate[]{cert});
        Logger.warn((String)"  saving changed keystore");
        this.storeKeystore();
        Logger.warn((String)"keystore password successfully changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void storeKeystore() throws Exception {
        FileOutputStream os = null;
        File target = this.getKeyStoreFile();
        boolean changed = target.exists();
        try {
            Logger.info((String)("storing keystore: " + target));
            os = new FileOutputStream(target);
            this.keystore.store(os, this.callback.getPassword().toCharArray());
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{os});
            this.keystore = null;
            this.certificate = null;
            this.privateKey = null;
            this.publicKey = null;
            this.sslContext = null;
            this.getSystemCertificate();
            if (changed) {
                Application.getMessagingFactory().sendMessage(new KeystoreChangedMessage());
            }
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{os});
        this.keystore = null;
        this.certificate = null;
        this.privateKey = null;
        this.publicKey = null;
        this.sslContext = null;
        this.getSystemCertificate();
        if (changed) {
            Application.getMessagingFactory().sendMessage(new KeystoreChangedMessage());
        }
    }

    public File getKeyStoreFile() {
        if (this.keystoreFile == null) {
            this.keystoreFile = new File(Application.getConfig().getConfigDir() + File.separator + "jameica.keystore");
        }
        return this.keystoreFile;
    }

    public synchronized PublicKey getPublicKey() throws Exception {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        return this.getSystemCertificate().getPublicKey();
    }

    public synchronized PrivateKey getPrivateKey() throws Exception {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = (PrivateKey)this.getKeyStore().getKey(SYSTEM_ALIAS, this.callback.getPassword().toCharArray());
        return this.privateKey;
    }

    public synchronized X509Certificate getSystemCertificate() throws Exception {
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = (X509Certificate)this.getKeyStore().getCertificate(SYSTEM_ALIAS);
        this.importSystemCertificate(CERT_UPDATES, "jameica.update");
        this.importSystemCertificate(CERT_JAMEICA_CA, "jameica.ca");
        this.importSystemCertificate(CERT_JAMEICA_UPDATE_CA, "jameica.update.ca1");
        return this.certificate;
    }

    private void importSystemCertificate(String data, String key) {
        try {
            X509Certificate cert = this.loadCertificate(new ByteArrayInputStream(data.getBytes("ISO-8859-1")));
            String alias = this.createAlias(cert);
            X509Certificate existing = this.getTrustedCertificate(alias);
            if (existing != null) {
                if (existing.equals(cert)) {
                    Logger.info((String)(key + " certificate correctly installed"));
                    return;
                }
                Logger.error((String)("found unknown " + key + " certificate, overwriting"));
                Logger.info((String)("old certificate was: " + existing));
            }
            if (existing == null) {
                if (settings.getString(key + ".cert.added", null) != null) {
                    Logger.info((String)(key + " certificate has been deleted by user, will not be imported again"));
                    return;
                }
                settings.setAttribute(key + ".cert.added", DateUtil.DEFAULT_FORMAT.format(new Date()));
                Logger.info((String)("importing built-in certificate " + key));
            }
            this.getKeyStore().setCertificateEntry(alias, cert);
            this.storeKeystore();
        }
        catch (Exception e) {
            Logger.error((String)("unable to import built-in certificate " + key), (Throwable)e);
        }
    }

    public synchronized X509Certificate[] getTrustedCertificates() throws Exception {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        Enumeration<String> e = this.getKeyStore().aliases();
        while (e.hasMoreElements()) {
            Certificate cert;
            String name = e.nextElement();
            if (SYSTEM_ALIAS.equals(name) || (cert = this.getKeyStore().getCertificate(name)).equals(this.getSystemCertificate())) continue;
            list.add(cert);
        }
        return list.toArray(new X509Certificate[list.size()]);
    }

    public X509Certificate getTrustedCertificate(String alias) throws Exception {
        if (alias == null || SYSTEM_ALIAS.equals(alias)) {
            return null;
        }
        return (X509Certificate)this.getKeyStore().getCertificate(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized X509Certificate[] getUnTrustedCertificates() throws Exception {
        File dir = new File(Application.getConfig().getWorkDir(), "untrusted");
        if (!dir.exists()) {
            return new X509Certificate[0];
        }
        FileFinder finder = new FileFinder(dir);
        finder.extension("crt");
        File[] certs = finder.find();
        if (certs == null || certs.length == 0) {
            return new X509Certificate[0];
        }
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(certs[i]);
                list.add(this.loadCertificate(is));
                continue;
            }
            catch (Exception e) {
                Logger.error((String)("unable to load certificate " + certs[i].getAbsolutePath()), (Throwable)e);
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        Logger.error((String)("unable to close certificate file " + certs[i].getAbsolutePath()), (Throwable)e);
                    }
                }
            }
        }
        return list.toArray(new X509Certificate[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized KeyStore getKeyStore() throws Exception {
        if (this.keystore != null) {
            return this.keystore;
        }
        File f = this.getKeyStoreFile();
        if (!(f.exists() && f.isFile() && f.canRead())) {
            throw new IOException("keystore " + f + " not found or not readable");
        }
        Logger.info((String)("init keystore " + f));
        this.keystore = KeyStore.getInstance("JKS");
        KeystoreVerifier verifier = new KeystoreVerifier(this.keystore, f);
        Logger.info((String)"trying to unlock keystore");
        String password = this.callback.getPassword(verifier);
        if (!verifier.verified) {
            BufferedInputStream is = null;
            try {
                Logger.info((String)"trying to read keystore");
                is = new BufferedInputStream(new FileInputStream(f));
                this.keystore.load(is, password.toCharArray());
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{is});
        }
        Logger.info((String)"keystore loaded successfully");
        return this.keystore;
    }

    public synchronized void removeTrustedCertificate(X509Certificate cert) throws Exception {
        if (cert == null) {
            throw new Exception("certificate cannot be null");
        }
        if (this.getSystemCertificate().equals(cert)) {
            throw new Exception("system certificate cannot be deleted");
        }
        Logger.warn((String)("removing certificate " + cert.getSubjectDN().getName() + " from keystore"));
        Logger.info((String)"searching for alias name");
        Enumeration<String> e = this.getKeyStore().aliases();
        while (e.hasMoreElements()) {
            X509Certificate c;
            String alias = e.nextElement();
            if (SYSTEM_ALIAS.equals(alias) || (c = (X509Certificate)this.getKeyStore().getCertificate(alias)) == null || c.equals(this.getSystemCertificate()) || !cert.equals(c)) continue;
            Logger.warn((String)("deleting certificate for alias " + alias));
            this.getKeyStore().deleteEntry(alias);
            this.storeKeystore();
            return;
        }
        Logger.warn((String)"given certificate not found in keystore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized X509Certificate loadCertificate(InputStream is) throws Exception {
        try {
            CertificateFactory cf = this.getCertificateFactory();
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(is);
            return x509Certificate;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<X509Certificate> loadCertificates(InputStream is) throws Exception {
        try {
            CertificateFactory cf = this.getCertificateFactory();
            Collection<? extends Certificate> collection = cf.generateCertificates(is);
            return collection;
        }
        finally {
            is.close();
        }
    }

    public synchronized CertificateFactory getCertificateFactory() throws Exception {
        if (this.factory == null) {
            this.factory = CertificateFactory.getInstance("X.509", "BC");
        }
        return this.factory;
    }

    private String createAlias(X509Certificate cert) {
        String dn = cert.getSubjectDN().getName();
        String alias = dn + "-" + cert.getSerialNumber().toString();
        return alias;
    }

    public synchronized String addTrustedCertificate(X509Certificate cert) throws Exception {
        String alias;
        block8: {
            alias = this.createAlias(cert);
            if (this.getSystemCertificate().equals(cert)) {
                throw new OperationCanceledException(Application.getI18n().tr("Das System-Zertifikat darf nicht \u00fcberschrieben werden"));
            }
            X509Certificate[] certs = this.getTrustedCertificates();
            if (certs != null && certs.length > 0) {
                for (int i = 0; i < certs.length; ++i) {
                    if (!cert.equals(certs[i])) continue;
                    Logger.info((String)("certificate " + alias + " already installed, skipping"));
                    return alias;
                }
            }
            Logger.info((String)"checking validity of certificate");
            DateFormat df = DateFormat.getDateInstance(2, Application.getConfig().getLocale());
            String validFrom = df.format(cert.getNotBefore());
            String validTo = df.format(cert.getNotAfter());
            try {
                cert.checkValidity();
            }
            catch (CertificateExpiredException exp) {
                String s = Application.getI18n().tr("Zertifikat abgelaufen. Trotzdem vertrauen?\nG\u00fcltigkeit: {0} - {1}", new String[]{validFrom, validTo});
                if (!Application.getCallback().askUser(s)) {
                    throw new OperationCanceledException(Application.getI18n().tr("Import des Zertifikats abgebrochen"));
                }
            }
            catch (CertificateNotYetValidException not) {
                String s = Application.getI18n().tr("Zertifikat noch nicht g\u00fcltig. Trotzdem vertrauen?\nG\u00fcltigkeit: {0} - {1}", new String[]{validFrom, validTo});
                if (Application.getCallback().askUser(s)) break block8;
                throw new OperationCanceledException(Application.getI18n().tr("Import des Zertifikats abgebrochen"));
            }
        }
        Logger.info((String)"checking trust of certificate");
        if (!Application.getCallback().checkTrust(cert)) {
            Logger.warn((String)("import of certificate " + alias + " cancelled by user, NOT trusted"));
            throw new OperationCanceledException(Application.getI18n().tr("Import des Zertifikats abgebrochen"));
        }
        Logger.warn((String)("adding certificate to keystore. alias: " + alias));
        this.getKeyStore().setCertificateEntry(alias, cert);
        this.storeKeystore();
        return alias;
    }

    public SSLContext getSSLContext() throws Exception {
        if (this.sslContext != null) {
            return this.sslContext;
        }
        Logger.info((String)"init ssl context");
        this.sslContext = SSLContext.getInstance("TLS");
        Logger.info((String)("init key manager [using algorithm: " + KeyManagerFactory.getDefaultAlgorithm() + "]"));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.getKeyStore(), this.callback.getPassword().toCharArray());
        Logger.info((String)"init Jameica trust manager");
        this.trustmanager = new JameicaTrustManager();
        this.sslContext.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{this.trustmanager}, null);
        Logger.info((String)"set jameica ssl context as system default");
        SSLContext.setDefault(this.sslContext);
        return this.sslContext;
    }

    public JameicaTrustManager getTrustManager() throws Exception {
        this.getSSLContext();
        return this.trustmanager;
    }

    public void encrypt(InputStream is, OutputStream os) throws Exception {
        RSAEngine e = new RSAEngine();
        e.encrypt(is, os);
    }

    public void decrypt(InputStream is, OutputStream os) throws Exception {
        RSAEngine e = new RSAEngine();
        e.decrypt(is, os);
    }

    static {
        if (Security.getProvider("BC") == null) {
            BouncyCastleProvider p = new BouncyCastleProvider();
            Logger.info((String)("applying security provider " + p.getInfo()));
            Security.addProvider((Provider)p);
        }
    }

    private class KeystoreVerifier
    implements LoginVerifier {
        private KeyStore keystore = null;
        private File file = null;
        private boolean verified = false;

        private KeystoreVerifier(KeyStore keystore, File file) {
            this.keystore = keystore;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * WARNING - bad return control flow
         */
        @Override
        public boolean verify(String username, char[] password) {
            boolean bl;
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(this.file));
                this.keystore.load(is, password);
                this.verified = true;
                bl = true;
            }
            catch (IOException ioe) {
                Logger.write((Level)Level.DEBUG, (String)"master password seems to be wrong", (Throwable)ioe);
                IOUtil.close((Closeable[])new Closeable[]{is});
            }
            catch (Exception e) {
                Logger.error((String)"unable to unlock keystore", (Throwable)e);
                {
                    catch (Throwable throwable) {
                        IOUtil.close((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                }
                IOUtil.close((Closeable[])new Closeable[]{is});
            }
            IOUtil.close((Closeable[])new Closeable[]{is});
            return bl;
            return false;
        }
    }
}

