/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security;

import de.willuhn.jameica.security.Login;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class JameicaAuthenticator
extends Authenticator {
    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        try {
            Login login = Application.getCallback().login(this);
            return login == null ? null : new PasswordAuthentication(login.getUsername(), login.getPassword());
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            throw new OperationCanceledException(e);
        }
    }

    public Object getRequestParam(RequestParam param) {
        switch (param) {
            case HOST: {
                return this.getRequestingHost();
            }
            case SITE: {
                return this.getRequestingSite();
            }
            case PORT: {
                return this.getRequestingPort();
            }
            case PROTOCOL: {
                return this.getRequestingProtocol();
            }
            case PROMPT: {
                return this.getRequestingPrompt();
            }
            case SCHEME: {
                return this.getRequestingScheme();
            }
            case URL: {
                return this.getRequestingURL();
            }
            case AUTHTYPE: {
                return this.getRequestorType();
            }
        }
        return null;
    }

    public static enum RequestParam {
        HOST,
        SITE,
        PORT,
        PROTOCOL,
        PROMPT,
        SCHEME,
        URL,
        AUTHTYPE;

    }
}

