/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.security;

import de.willuhn.jameica.security.Principal;
import de.willuhn.logging.Logger;
import de.willuhn.security.Checksum;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.cert.CertificateEncodingException;

public class Certificate {
    private X509Certificate cert = null;
    private javax.security.cert.X509Certificate cert2 = null;

    public Certificate(java.security.cert.Certificate cert) {
        if (cert instanceof X509Certificate) {
            this.cert = (X509Certificate)cert;
        }
    }

    public Certificate(X509Certificate cert) {
        this.cert = cert;
    }

    public Certificate(javax.security.cert.X509Certificate cert) {
        this.cert2 = cert;
    }

    public String getMD5Fingerprint() throws java.security.cert.CertificateEncodingException, NoSuchAlgorithmException {
        return this.getFingerprint("MD5");
    }

    public String getSHA1Fingerprint() throws java.security.cert.CertificateEncodingException, NoSuchAlgorithmException {
        return this.getFingerprint("SHA1");
    }

    public String getSHA256Fingerprint() throws java.security.cert.CertificateEncodingException, NoSuchAlgorithmException {
        return this.getFingerprint("SHA-256");
    }

    private String getFingerprint(String algorithm) throws java.security.cert.CertificateEncodingException, NoSuchAlgorithmException {
        byte[] sig = null;
        if (this.cert != null) {
            sig = this.cert.getEncoded();
        } else {
            try {
                sig = this.cert2.getEncoded();
            }
            catch (CertificateEncodingException e) {
                Logger.error((String)"error while encoding certificate", (Throwable)e);
                throw new java.security.cert.CertificateEncodingException(e.getMessage());
            }
        }
        byte[] digest = Checksum.checksum((byte[])sig, (String)algorithm);
        StringBuffer sb = new StringBuffer(2 * digest.length);
        for (int i = 0; i < digest.length; ++i) {
            int k = digest[i] & 0xFF;
            if (k < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(k));
            if (i + 1 >= digest.length) continue;
            sb.append(":");
        }
        return sb.toString().toUpperCase();
    }

    public Principal getSubject() {
        if (this.cert != null) {
            return new Principal(this.cert.getSubjectDN());
        }
        return new Principal(this.cert2.getSubjectDN());
    }

    public Principal getIssuer() {
        if (this.cert != null) {
            return new Principal(this.cert.getIssuerDN());
        }
        return new Principal(this.cert2.getIssuerDN());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getHostnames() {
        ArrayList<String> result = new ArrayList<String>();
        String h = this.getSubject().getAttribute("CN");
        if (h != null && !h.isEmpty()) {
            result.add(h);
        }
        if (this.cert != null) {
            try {
                Collection<List<?>> altNames = this.cert.getSubjectAlternativeNames();
                if (altNames == null || altNames.isEmpty()) return result;
                for (List<?> altName : altNames) {
                    Integer t;
                    String value;
                    Object type;
                    if (altName.size() < 2 || !((type = altName.get(0)) instanceof Integer) || (value = this.getAltNameValue(altName.get(1))) == null || !(t = (Integer)type).equals(2) && !t.equals(7)) continue;
                    result.add(value);
                }
                return result;
            }
            catch (Exception e) {
                Logger.error((String)"unable to read subject-alt-names from certificate", (Throwable)e);
                return result;
            }
        } else {
            if (this.cert2 == null) return result;
            Logger.warn((String)"extracting of subject-alt-names from javax.security.cert.X509Certificate not supported");
        }
        return result;
    }

    private String getAltNameValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof byte[]) {
            Logger.warn((String)"encoded subject-alt-names not yet supported");
        }
        return null;
    }
}

