/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.reminder;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.reminder.AbstractReminderStorageProvider;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.security.Wallet;
import de.willuhn.jameica.security.crypto.AESEngine;
import de.willuhn.jameica.services.ReminderService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.JameicaException;
import org.apache.commons.lang.StringUtils;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class ReminderStorageProviderWallet
extends AbstractReminderStorageProvider {
    private Wallet wallet = null;

    private synchronized Wallet getWallet() throws Exception {
        if (this.wallet == null) {
            this.wallet = new Wallet(ReminderService.class, new AESEngine());
        }
        return this.wallet;
    }

    @Override
    public Reminder get(String uuid) throws Exception {
        if (StringUtils.trimToNull((String)uuid) == null) {
            throw new JameicaException("no uuid given");
        }
        return (Reminder)this.getWallet().get(uuid);
    }

    @Override
    public Reminder delete(String uuid) throws Exception {
        if (StringUtils.trimToNull((String)uuid) == null) {
            throw new JameicaException("no uuid given");
        }
        Reminder r = (Reminder)this.getWallet().delete(uuid);
        if (r == null) {
            return null;
        }
        Application.getMessagingFactory().getMessagingQueue("jameica.reminder.deleted").sendMessage(new QueryMessage(r));
        return r;
    }

    @Override
    public String add(Reminder reminder) throws Exception {
        if (reminder == null) {
            throw new JameicaException("no reminder given");
        }
        String uuid = this.createUUID();
        this.getWallet().set(uuid, reminder);
        Application.getMessagingFactory().getMessagingQueue("jameica.reminder.added").sendMessage(new QueryMessage(reminder));
        return uuid;
    }

    @Override
    public void update(String uuid, Reminder reminder) throws Exception {
        if (StringUtils.trimToNull((String)uuid) == null) {
            throw new JameicaException("no uuid given");
        }
        if (reminder == null) {
            throw new JameicaException("no reminder given");
        }
        if (this.getWallet().get(uuid) == null) {
            throw new JameicaException("no reminder found for uuid: " + uuid);
        }
        this.getWallet().set(uuid, reminder);
        Application.getMessagingFactory().getMessagingQueue("jameica.reminder.updated").sendMessage(new QueryMessage(reminder));
    }

    @Override
    public String[] getUUIDs() throws Exception {
        return this.getWallet().getAll(null);
    }
}

