/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.reminder;

import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ReminderInterval
implements Serializable {
    private TimeUnit unit = TimeUnit.MONTHS;
    private int interval = 1;

    public ReminderInterval() {
    }

    public ReminderInterval(TimeUnit unit, int interval) {
        this.unit = unit;
        this.interval = interval;
    }

    public TimeUnit getTimeUnit() {
        return this.unit;
    }

    public void setTimeUnit(TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("timeunit missing");
        }
        this.unit = unit;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("invalid interval: " + interval);
        }
        this.interval = interval;
    }

    public List<Date> getDates(Date start, Date from, Date to) {
        if (start == null) {
            throw new IllegalArgumentException("start date missing");
        }
        if (from == null) {
            from = start;
        }
        if (to == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(from);
            cal.add(1, 1);
            to = cal.getTime();
        }
        ArrayList<Date> list = new ArrayList<Date>();
        if (!to.after(from)) {
            Logger.warn((String)("end-date " + DateUtil.DEFAULT_FORMAT.format(to) + " not after from-date " + DateUtil.DEFAULT_FORMAT.format(from)));
            return list;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        int field = this.getTimeUnit().getCalendarField();
        while (!start.after(to)) {
            if (start.after(from) || start.equals(from)) {
                list.add(start);
            }
            cal.add(field, this.getInterval());
            start = cal.getTime();
        }
        return list;
    }

    public String toString() {
        I18N i18n = Application.getI18n();
        int i = this.interval;
        if (this.unit == TimeUnit.HOURS) {
            if (i == 1) {
                return i18n.tr("st\u00fcndlich");
            }
            if (i == 24) {
                return i18n.tr("t\u00e4glich");
            }
            return i18n.tr("alle {0} Stunden", Integer.toString(i));
        }
        if (this.unit == TimeUnit.DAYS) {
            if (i == 1) {
                return i18n.tr("t\u00e4glich");
            }
            if (i == 7) {
                return i18n.tr("w\u00f6chentlich");
            }
            return i18n.tr("alle {0} Tage", Integer.toString(i));
        }
        if (this.unit == TimeUnit.WEEKS) {
            if (i == 1) {
                return i18n.tr("w\u00f6chentlich");
            }
            return i18n.tr("alle {0} Wochen", Integer.toString(i));
        }
        if (this.unit == TimeUnit.MONTHS) {
            if (i == 1) {
                return i18n.tr("monatlich");
            }
            if (i == 3) {
                return i18n.tr("viertelj\u00e4hrlich");
            }
            if (i == 6) {
                return i18n.tr("halbj\u00e4hrlich");
            }
            if (i == 12) {
                return i18n.tr("j\u00e4hrlich");
            }
            return i18n.tr("alle {0} Monate", Integer.toString(i));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("every ");
        sb.append(this.interval);
        sb.append(" ");
        sb.append(this.unit.toString().toLowerCase());
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ReminderInterval ri = (ReminderInterval)other;
        return this.interval == ri.interval && this.unit == ri.unit;
    }

    public static enum TimeUnit {
        HOURS(10),
        DAYS(5),
        WEEKS(3),
        MONTHS(2);

        private final int calendarField;

        private TimeUnit(int field) {
            this.calendarField = field;
        }

        public int getCalendarField() {
            return this.calendarField;
        }
    }
}

