/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.reminder;

import de.willuhn.jameica.reminder.ReminderInterval;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class Reminder
implements Serializable {
    static final long serialVersionUID = 2569493156799107871L;
    public static final String QUEUE_DEFAULT = "jameica.reminder";
    public static final String KEY_EXECUTED = "jameica.reminder.key.executed";
    public static final String KEY_EXPIRED = "jameica.reminder.key.expired";
    private String queue = "jameica.reminder";
    private Date date = new Date();
    private ReminderInterval interval = null;
    private Date end = null;
    private HashMap<String, Serializable> data = new HashMap();

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date due) {
        if (due == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        this.date = due;
    }

    public ReminderInterval getReminderInterval() {
        return this.interval;
    }

    public void setReminderInterval(ReminderInterval interval) {
        this.interval = interval;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Serializable getData(String key) {
        return this.data.get(key);
    }

    public Map<String, Serializable> getData() {
        return (Map)this.data.clone();
    }

    public void setData(Map<String, Serializable> data) {
        this.data.putAll(data);
    }

    public void setData(String key, Serializable data) {
        this.data.put(key, data);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.interval != null) {
            sb.append(this.interval);
            sb.append(", starting at ");
            sb.append(this.date);
            if (this.end != null) {
                sb.append(", ending at ");
                sb.append(this.date);
            }
        } else {
            sb.append(this.date);
        }
        sb.append(": [");
        sb.append(this.queue);
        sb.append("] ");
        sb.append(this.data);
        return sb.toString();
    }
}

