/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZippedPlugin {
    private File file = null;
    private String name = null;
    private Manifest manifest = null;

    public ZippedPlugin(File zip) throws ApplicationException {
        I18N i18n = Application.getI18n();
        if (zip == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie das zu installierende Plugin"));
        }
        if (!zip.getName().endsWith(".zip")) {
            throw new ApplicationException(i18n.tr("Keine g\u00fcltige ZIP-Datei"));
        }
        ApplicationException ae = new ApplicationException(i18n.tr("Kein g\u00fcltiges Jameica-Plugin"));
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip, 1);
            ZipEntry dir = null;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.contains("/")) {
                    Logger.error((String)(zip + " contains invalid file " + name));
                    throw ae;
                }
                if (name.matches(".{1,}?/.{1,}")) continue;
                if (!entry.isDirectory()) {
                    Logger.error((String)"plugin zip-file must contain only one folder");
                    throw ae;
                }
                if (dir != null) {
                    Logger.error((String)"plugin zip-file must contain only one folder");
                    throw ae;
                }
                dir = entry;
            }
            if (dir == null) {
                Logger.error((String)"plugin zip-file empty");
                throw ae;
            }
            String s = dir.getName();
            this.name = s.substring(0, s.length() - 1).trim();
            if (this.name.length() == 0 || this.name.contains("/") || this.name.contains("..")) {
                Logger.error((String)("plugin folder " + this.name + " invalid"));
                throw ae;
            }
            ZipEntry entry = zipFile.getEntry(dir.getName() + "plugin.xml");
            if (entry == null || entry.isDirectory()) {
                Logger.error((String)"plugin zip-file contains no plugin.xml");
                throw ae;
            }
            InputStream is = zipFile.getInputStream(entry);
            if (is == null) {
                Logger.error((String)"plugin zip-file contains no plugin.xml");
                throw ae;
            }
            this.manifest = new Manifest(is);
            if (this.manifest.isSystemManifest()) {
                throw new ApplicationException(i18n.tr("Die Datei enth\u00e4lt kein Plugin sondern Jameica selbst"));
            }
            this.file = zip;
        }
        catch (ApplicationException ae2) {
            throw ae2;
        }
        catch (Exception e) {
            Logger.error((String)("unable to check zip file " + zip), (Throwable)e);
            throw ae;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public File getFile() {
        return this.file;
    }
}

