/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.logging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = -8081873180699134869L;
    public static final Version NONE = new Version();
    private Integer major = null;
    private Integer minor = null;
    private Integer patch = null;
    private String suffix = null;

    public Version() {
    }

    public Version(String v) {
        ArrayList<String> parts;
        v = StringUtils.trimToNull((String)v);
        if (v == null) {
            return;
        }
        int spos = v.indexOf("-");
        if (spos > 0) {
            this.suffix = v.substring(spos + 1);
            v = v.substring(0, spos);
        }
        if ((parts = new ArrayList<String>(Arrays.asList(v.split("\\.")))).size() > 0) {
            this.major = this.parse((String)parts.remove(0));
        }
        if (parts.size() > 0) {
            this.minor = this.parse((String)parts.remove(0));
        }
        if (parts.size() > 0) {
            this.patch = this.parse((String)parts.remove(0));
        }
    }

    private Integer parse(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (Exception e) {
            Logger.error((String)("unparsable version part: " + part), (Throwable)e);
            return null;
        }
    }

    public int getMajor() {
        return this.major != null ? this.major : 0;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor != null ? this.minor : 0;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch != null ? this.patch : 0;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.major == null ? 0 : this.major.hashCode());
        result = 31 * result + (this.minor == null ? 0 : this.minor.hashCode());
        result = 31 * result + (this.patch == null ? 0 : this.patch.hashCode());
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major == null ? other.major != null : !this.major.equals(other.major)) {
            return false;
        }
        if (this.minor == null ? other.minor != null : !this.minor.equals(other.minor)) {
            return false;
        }
        if (this.patch == null ? other.patch != null : !this.patch.equals(other.patch)) {
            return false;
        }
        return !(this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix));
    }

    @Override
    public int compareTo(Version v) {
        int r = this.getMajor() - v.getMajor();
        if (r == 0 && (r = this.getMinor() - v.getMinor()) == 0) {
            r = this.getPatch() - v.getPatch();
        }
        return r;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMajor());
        sb.append(".");
        sb.append(this.getMinor());
        sb.append(".");
        sb.append(this.getPatch());
        if (this.getSuffix() != null && this.getSuffix().length() > 0) {
            sb.append("-");
            sb.append(this.getSuffix());
        }
        return sb.toString();
    }

    public boolean compliesTo(String dependency) {
        if (dependency == null || dependency.length() == 0) {
            return true;
        }
        try {
            String cleaned = dependency.replaceAll("[\\(\\)\\-\\+]", "");
            Version required = new Version(cleaned);
            if (dependency.endsWith("(+)")) {
                if (required.minor == null && required.patch == null) {
                    return this.getMajor() >= required.getMajor();
                }
                if (required.patch == null) {
                    return this.getMajor() == required.getMajor() && this.getMinor() >= required.getMinor();
                }
                return this.getMajor() == required.getMajor() && this.getMinor() == required.getMinor() && this.getPatch() >= required.getPatch();
            }
            if (dependency.endsWith("(-)")) {
                if (required.minor == null && required.patch == null) {
                    return this.getMajor() <= required.getMajor();
                }
                if (required.patch == null) {
                    return this.getMajor() == required.getMajor() && this.getMinor() <= required.getMinor();
                }
                return this.getMajor() == required.getMajor() && this.getMinor() == required.getMinor() && this.getPatch() <= required.getPatch();
            }
            int compare = this.compareTo(required);
            if (dependency.endsWith("+")) {
                return compare >= 0;
            }
            if (dependency.endsWith("-")) {
                return compare <= 0;
            }
            return compare == 0;
        }
        catch (Exception e) {
            Logger.error((String)("invalid version number: " + dependency + " - " + e.getMessage()), (Throwable)e);
            return false;
        }
    }
}

