/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import de.willuhn.util.MultipleClassLoader;
import java.io.File;
import java.util.Locale;

public final class PluginResources {
    private Plugin plugin = null;
    private I18N i18n = null;
    private String workPath = null;
    private Settings settings = null;

    protected PluginResources(Plugin plugin) {
        this.plugin = plugin;
        this.settings = new Settings(plugin.getClass());
        this.settings.setStoreWhenRead(false);
    }

    public I18N getI18N() {
        if (this.i18n != null) {
            return this.i18n;
        }
        Locale locale = Application.getConfig().getLocale();
        try {
            try {
                this.i18n = new I18N("lang/" + this.plugin.getManifest().getName().replaceAll("\\.", "_") + "_messages", locale, (ClassLoader)this.plugin.getManifest().getClassLoader());
            }
            catch (Exception e) {
                this.i18n = new I18N("lang/messages", locale, (ClassLoader)this.plugin.getManifest().getClassLoader());
            }
        }
        catch (Exception e) {
            Logger.info((String)("plugin " + this.plugin.getClass().getName() + " does not support jameicas locale " + locale));
            this.i18n = Application.getI18n();
        }
        return this.i18n;
    }

    public String getWorkPath() {
        String check;
        if (this.workPath != null) {
            return this.workPath;
        }
        this.workPath = Application.getConfig().getWorkDir();
        File pluginPath = new File(this.plugin.getManifest().getPluginDir());
        String name = pluginPath.getName();
        if (!name.equals(check = this.plugin.getManifest().getName())) {
            Logger.error((String)("pluginname (" + check + ") and workdir (" + name + ") differs, this may cause problems!"));
        }
        this.workPath = this.workPath + File.separator + name;
        File f = new File(this.workPath);
        if (!f.exists() && !f.mkdirs()) {
            Logger.error((String)("unable to create work dir " + this.workPath));
            throw new RuntimeException("unable to create work dir " + this.workPath);
        }
        return this.workPath;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public MultipleClassLoader getClassLoader() {
        return this.plugin.getManifest().getClassLoader();
    }
}

