/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.jameica.gui.MenuItem;
import de.willuhn.jameica.gui.MenuItemXml;
import de.willuhn.jameica.gui.NavigationItem;
import de.willuhn.jameica.gui.NavigationItemXml;
import de.willuhn.jameica.plugin.ConsumerDescriptor;
import de.willuhn.jameica.plugin.Dependency;
import de.willuhn.jameica.plugin.ExtensionDescriptor;
import de.willuhn.jameica.plugin.MessageDescriptor;
import de.willuhn.jameica.plugin.PlaceholderPlugin;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.plugin.ServiceDescriptor;
import de.willuhn.jameica.plugin.Version;
import de.willuhn.jameica.services.PluginSourceService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.MultipleClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLParserFactory;

public class Manifest
implements Comparable {
    private File manifest = null;
    private IXMLElement root = null;
    private String[] cfInclude = null;
    private NavigationItem navi = null;
    private MenuItem menu = null;
    private Plugin pluginInstance = null;
    private MultipleClassLoader loader = null;
    private PluginSource.Type source = null;
    private boolean isInstalled = false;
    private String buildnumber = "";
    private String builtdate = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest(File manifest) throws Exception {
        if (manifest == null) {
            throw new IOException("no manifest (plugin.xml) given");
        }
        if (!manifest.exists() || !manifest.canRead()) {
            throw new IOException("manifest " + manifest.getAbsolutePath() + " not readable");
        }
        this.manifest = manifest;
        this.read(new FileInputStream(manifest));
        Logger.info((String)(this.getName() + " " + this.getVersion()));
        Logger.info((String)("  Directory  : " + this.getPluginDir()));
        ZipFile jar = null;
        try {
            jar = new JarFile(this.getPluginDir() + File.separator + this.getName() + ".jar");
            java.util.jar.Manifest mf = ((JarFile)jar).getManifest();
            this.buildnumber = mf.getMainAttributes().getValue("Implementation-Buildnumber");
            this.builtdate = mf.getMainAttributes().getValue("Built-Date");
            Logger.info((String)("  Buildnumber: " + this.buildnumber));
            Logger.info((String)("  Built-Date : " + this.builtdate));
        }
        catch (Exception e) {
            Logger.debug((String)"unable to read jar manifest, running uncompressed within debugger?");
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close jar file", (Throwable)e);
                }
            }
        }
    }

    public Manifest(InputStream manifest) throws Exception {
        if (manifest == null) {
            throw new IOException("no manifest (plugin.xml) given");
        }
        this.read(manifest);
    }

    private void read(InputStream is) throws Exception {
        IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
        parser.setReader((IXMLReader)new StdXMLReader(is));
        this.root = (IXMLElement)parser.parse();
    }

    public String getPluginDir() {
        if (this.manifest == null) {
            return null;
        }
        String s = this.manifest.getParent();
        if (s != null) {
            return s;
        }
        try {
            File canonical = this.manifest.getCanonicalFile();
            return canonical.getParent();
        }
        catch (IOException ioe) {
            Logger.error((String)("unable to determine parent directory of " + this.manifest.getAbsolutePath() + ", using \".\""), (Throwable)ioe);
            return ".";
        }
    }

    public Version getVersion() {
        try {
            return new Version(this.root.getAttribute("version", "1.0"));
        }
        catch (Exception e) {
            return new Version();
        }
    }

    public final String getBuildnumber() {
        return this.buildnumber;
    }

    public final String getBuildDate() {
        return this.builtdate;
    }

    public String getName() {
        return this.root.getAttribute("name", null);
    }

    public String getPluginClass() {
        if (this.pluginInstance != null) {
            return this.pluginInstance.getClass().getName();
        }
        String className = this.root.getAttribute("class", null);
        if (className == null) {
            this.pluginInstance = PlaceholderPlugin.createInstance(this);
            return this.pluginInstance.getClass().getName();
        }
        return className.trim();
    }

    public String getPluginId() {
        Class<?> clazz;
        if (this.pluginInstance == null) {
            String className = this.root.getAttribute("class", null);
            if (className != null) {
                return className.trim();
            }
            this.pluginInstance = PlaceholderPlugin.createInstance(this);
        }
        if (Proxy.isProxyClass(clazz = this.pluginInstance.getClass())) {
            return this.getName();
        }
        return clazz.getName();
    }

    public boolean isShared() {
        return "true".equalsIgnoreCase(this.root.getAttribute("shared", "true"));
    }

    public boolean isSystemManifest() {
        String name = this.root.getName();
        return name != null && name.equals("system");
    }

    public String getDescription() {
        IXMLElement desc = this.root.getFirstChildNamed("description");
        return desc == null ? null : desc.getContent();
    }

    public String getURL() {
        IXMLElement desc = this.root.getFirstChildNamed("url");
        return desc == null ? null : desc.getContent();
    }

    public String getHomepage() {
        IXMLElement desc = this.root.getFirstChildNamed("homepage");
        return desc == null ? null : desc.getContent();
    }

    public boolean validateHomepage() {
        IXMLElement homepage = this.root.getFirstChildNamed("homepage");
        if (homepage == null) {
            return false;
        }
        String b = homepage.getAttribute("validate", null);
        return Boolean.parseBoolean(b);
    }

    public String getLicense() {
        IXMLElement desc = this.root.getFirstChildNamed("license");
        return desc == null ? null : desc.getContent();
    }

    public String getIcon() {
        IXMLElement desc = this.root.getFirstChildNamed("icon");
        return desc == null ? null : desc.getContent();
    }

    public MenuItem getMenu() {
        IXMLElement e;
        if (this.menu != null) {
            return this.menu;
        }
        I18N i18n = Application.getI18n();
        if (this.pluginInstance != null) {
            try {
                i18n = this.pluginInstance.getResources().getI18N();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.menu = (e = this.root.getFirstChildNamed("menu")) == null ? null : new MenuItemXml(null, e, i18n);
        return this.menu;
    }

    public NavigationItem getNavigation() {
        IXMLElement e;
        if (this.navi != null) {
            return this.navi;
        }
        I18N i18n = Application.getI18n();
        if (this.pluginInstance != null) {
            try {
                i18n = this.pluginInstance.getResources().getI18N();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.navi = (e = this.root.getFirstChildNamed("navigation")) == null ? null : new NavigationItemXml(null, e, i18n);
        return this.navi;
    }

    public ServiceDescriptor[] getServices() {
        IXMLElement services = this.root.getFirstChildNamed("services");
        if (services == null || !services.hasChildren()) {
            return new ServiceDescriptor[0];
        }
        Vector v = services.getChildrenNamed("service");
        ServiceDescriptor[] s = new ServiceDescriptor[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            s[i] = new ServiceDescriptor((IXMLElement)v.get(i));
        }
        return s;
    }

    public String[] getClassFinderIncludes() {
        if (this.cfInclude != null) {
            return this.cfInclude;
        }
        IXMLElement finder = this.root.getFirstChildNamed("classfinder");
        if (finder == null || !finder.hasChildren()) {
            return new String[0];
        }
        Vector v = finder.getChildrenNamed("include");
        this.cfInclude = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            this.cfInclude[i] = ((IXMLElement)v.get(i)).getContent();
        }
        return this.cfInclude;
    }

    public ExtensionDescriptor[] getExtensions() {
        IXMLElement extensions = this.root.getFirstChildNamed("extensions");
        if (extensions == null || !extensions.hasChildren()) {
            return null;
        }
        Vector v = extensions.getChildrenNamed("extension");
        LinkedList<ExtensionDescriptor> list = new LinkedList<ExtensionDescriptor>();
        for (Object e : v) {
            list.add(new ExtensionDescriptor((IXMLElement)e));
        }
        return list.toArray(new ExtensionDescriptor[list.size()]);
    }

    public ConsumerDescriptor[] getMessageConsumers() {
        IXMLElement messaging = this.root.getFirstChildNamed("messaging");
        if (messaging == null || !messaging.hasChildren()) {
            return null;
        }
        Vector v = messaging.getChildrenNamed("consumer");
        ConsumerDescriptor[] s = new ConsumerDescriptor[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            s[i] = new ConsumerDescriptor((IXMLElement)v.get(i));
        }
        return s;
    }

    public MessageDescriptor[] getMessages() {
        IXMLElement messaging = this.root.getFirstChildNamed("messaging");
        if (messaging == null || !messaging.hasChildren()) {
            return null;
        }
        Vector v = messaging.getChildrenNamed("message");
        MessageDescriptor[] s = new MessageDescriptor[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            s[i] = new MessageDescriptor(this, (IXMLElement)v.get(i));
        }
        return s;
    }

    public Dependency getJameicaDependency() {
        IXMLElement req = this.root.getFirstChildNamed("requires");
        return new Dependency("jameica", req == null ? null : req.getAttribute("jameica", null));
    }

    public Dependency[] getDirectDependencies() {
        IXMLElement deps = this.root.getFirstChildNamed("requires");
        if (deps == null || !deps.hasChildren()) {
            return new Dependency[0];
        }
        ArrayList<Dependency> found = new ArrayList<Dependency>();
        Vector v = deps.getChildrenNamed("import");
        for (int i = 0; i < v.size(); ++i) {
            IXMLElement plugin = (IXMLElement)v.get(i);
            String name = plugin.getAttribute("plugin", null);
            if (name == null || name.length() == 0) continue;
            boolean required = Boolean.valueOf(plugin.getAttribute("required", "true"));
            Dependency dep = new Dependency(name, plugin.getAttribute("version", null), required);
            found.add(dep);
        }
        return found.toArray(new Dependency[found.size()]);
    }

    public Dependency[] getDependencies() {
        Dependency[] direct = this.getDirectDependencies();
        if (direct.length == 0) {
            return direct;
        }
        ArrayList<Dependency> found = new ArrayList<Dependency>();
        ArrayList<String> toCheck = new ArrayList<String>();
        for (Dependency d : direct) {
            found.add(d);
            toCheck.add(d.getName());
        }
        List<Manifest> all = Application.getPluginLoader().getManifests();
        for (int i = 0; i < all.size(); ++i) {
            Dependency[] secondDeps;
            Manifest mf = all.get(i);
            String name = mf.getName();
            if (!toCheck.contains(name) || (secondDeps = mf.getDependencies()) == null || secondDeps.length == 0) continue;
            for (int k = 0; k < secondDeps.length; ++k) {
                if (found.contains(secondDeps[k])) continue;
                found.add(secondDeps[k]);
            }
        }
        return found.toArray(new Dependency[found.size()]);
    }

    public void canDeploy() throws ApplicationException {
        this.canDeploy(true);
    }

    public void canDeploy(boolean checkDeps) throws ApplicationException {
        Dependency jd = this.getJameicaDependency();
        if (!jd.check()) {
            throw new ApplicationException(Application.getI18n().tr("Plugin {0} ben\u00f6tigt Jameica {1}", new String[]{this.getName(), jd.getVersion()}));
        }
        if (Application.getPluginLoader().isObsolete(this.getName())) {
            throw new ApplicationException(Application.getI18n().tr("Plugin ist jetzt Bestandteil von Jameica und muss daher nicht mehr installiert werden"));
        }
        if (checkDeps) {
            Dependency[] deps;
            for (Dependency d : deps = this.getDirectDependencies()) {
                if (d.check()) continue;
                throw new ApplicationException(Application.getI18n().tr("Plugin {0} ben\u00f6tigt {1}, welches aber nicht (oder in der falschen Version) installiert ist", new String[]{this.getName(), d.getName()}));
            }
        }
        Manifest installed = null;
        List<Manifest> list = Application.getPluginLoader().getInstalledManifests();
        for (Manifest m : list) {
            if (!m.getName().equals(this.getName())) continue;
            installed = m;
            break;
        }
        if (installed == null) {
            return;
        }
        PluginSourceService sources = (PluginSourceService)Application.getBootLoader().getBootable(PluginSourceService.class);
        PluginSource ps = sources.getSource(installed.getPluginSource());
        if (ps == null) {
            throw new ApplicationException(Application.getI18n().tr("Plugin {0} kann nicht aktualisiert werden, da die Installationsquelle unbekannt ist", this.getName()));
        }
        if (!ps.canWrite()) {
            throw new ApplicationException(Application.getI18n().tr("Plugin {0} kann nicht aktualisiert werden, da der Plugin-Ordner nicht beschrieben werden darf", this.getName()));
        }
        if (installed.getVersion().compareTo(this.getVersion()) > 0) {
            throw new ApplicationException(Application.getI18n().tr("Plugin {0} ist bereits in einer aktuelleren Version installiert", this.getName()));
        }
    }

    Plugin getPluginInstance() {
        return this.pluginInstance;
    }

    void setPluginInstance(Plugin plugin) {
        if (this.pluginInstance == null) {
            this.pluginInstance = plugin;
        }
    }

    public void setPluginSource(PluginSource.Type type) {
        this.source = type;
    }

    public PluginSource.Type getPluginSource() {
        return this.source;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public void setInstalled(boolean b) {
        this.isInstalled = b;
    }

    public boolean isLoaded() {
        return this.loader != null;
    }

    public MultipleClassLoader getClassLoader() {
        return this.loader;
    }

    void setClassLoader(MultipleClassLoader loader) {
        this.loader = loader;
    }

    public int compareTo(Object o) {
        int i;
        String name = this.getName();
        if (name == null || name.length() == 0) {
            Logger.debug((String)("1: " + name + " > <unknown>"));
            return -1;
        }
        if (o == null || !(o instanceof Manifest)) {
            Logger.debug((String)("2: " + name + " > <unknown>"));
            return -1;
        }
        Manifest other = (Manifest)o;
        String otherName = other.getName();
        if (otherName == null || otherName.length() == 0) {
            Logger.debug((String)("3: " + otherName + " > " + name));
            return 1;
        }
        Dependency[] deps = other.getDependencies();
        if (deps == null || deps.length == 0) {
            Logger.debug((String)("4: " + otherName + " > " + name));
            return 1;
        }
        for (i = 0; i < deps.length; ++i) {
            if (deps[i] == null || !name.equals(deps[i].getName())) continue;
            Logger.debug((String)("5: " + name + " > " + otherName));
            return -1;
        }
        deps = this.getDependencies();
        if (deps == null || deps.length == 0) {
            Logger.debug((String)("6: " + name + " > " + otherName));
            return -1;
        }
        for (i = 0; i < deps.length; ++i) {
            if (deps[i] == null || !otherName.equals(deps[i].getName())) continue;
            Logger.debug((String)("7: " + otherName + " > " + name));
            return 1;
        }
        Logger.debug((String)("8: " + name + " <> " + otherName));
        return 0;
    }
}

