/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.plugin;

import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.system.Application;
import java.io.Serializable;
import java.util.List;

public class Dependency
implements Serializable {
    private String name = null;
    private String version = null;
    private boolean required = true;

    public Dependency(String name, String version) {
        this(name, version, true);
    }

    public Dependency(String name, String version, boolean required) {
        if (name == null) {
            throw new NullPointerException("no plugin name given in dependency");
        }
        this.name = name;
        this.version = version;
        this.required = required;
    }

    public String toString() {
        return this.name + ": " + (this.version == null ? "<any>" : this.version.toString());
    }

    public boolean check() {
        if (this.name.equalsIgnoreCase("jameica")) {
            return Application.getManifest().getVersion().compliesTo(this.version);
        }
        if (Application.getPluginLoader().isObsolete(this.name)) {
            return true;
        }
        if (!this.isRequired()) {
            return true;
        }
        List<Manifest> all = Application.getPluginLoader().getManifests();
        for (int i = 0; i < all.size(); ++i) {
            Manifest mf = all.get(i);
            String n = mf.getName();
            if (n == null || !this.name.equals(n)) continue;
            return mf.isLoaded() && mf.getVersion().compliesTo(this.version);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRequired() {
        if (Application.getPluginLoader().isObsolete(this.name)) {
            return false;
        }
        return this.required;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

