/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageBus;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.services.LockService;
import de.willuhn.jameica.system.Application;

public class UncleanShutdownMessageConsumer
implements MessageConsumer {
    @Override
    public boolean autoRegister() {
        return true;
    }

    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{SystemMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        SystemMessage m = (SystemMessage)message;
        if (m.getStatusCode() != 1) {
            return;
        }
        LockService service = (LockService)Application.getBootLoader().getBootable(LockService.class);
        if (service.foundUncleanShutdown()) {
            MessageBus.queue("jameica.shutdown.unclean", Boolean.TRUE);
        }
    }
}

