/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.gui.dialogs.CertificateTrustDialog;
import de.willuhn.jameica.messaging.CheckTrustMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.net.URL;

public class SystemRepositoryTrustMessageConsumer
implements MessageConsumer {
    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{CheckTrustMessage.class};
    }

    public void performTrust() throws ApplicationException {
        try {
            Logger.info((String)"open system plugin repository to verify trust state");
            Application.getMessagingFactory().registerMessageConsumer(this);
            RepositoryService rs = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
            rs.open(new URL("https://www.willuhn.de/products/jameica/updates"));
            Logger.info((String)"trust to system plugin repository granted");
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new ApplicationException(Application.getI18n().tr("\u00d6ffnen des System-Plugin-Repository fehlgeschlagen: {0}", e.getMessage()), (Throwable)e);
        }
        finally {
            Application.getMessagingFactory().unRegisterMessageConsumer(this);
        }
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        CheckTrustMessage msg = (CheckTrustMessage)message;
        if (Application.inServerMode() || Application.inNonInteractiveMode()) {
            return;
        }
        CertificateTrustDialog d = new CertificateTrustDialog(1, msg.getCertificate());
        d.setText(Application.getI18n().tr("Bitte pr\u00fcfen Sie, ob das angezeigte Zertifikat mit dem Server-Zertifikat des\nWebservers www.willuhn.de \u00fcbereinstimmt."));
        try {
            Boolean b = (Boolean)d.open();
            msg.setTrusted(b, "user via certificate dialog");
        }
        catch (Exception e) {
            msg.setException(e);
        }
    }

    @Override
    public boolean autoRegister() {
        return false;
    }
}

