/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.services.ScriptingService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class RemoveScriptMessageConsumer
implements MessageConsumer {
    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{QueryMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        QueryMessage msg = (QueryMessage)message;
        Object data = msg.getData();
        if (data == null) {
            Logger.warn((String)"no message data given, ignoring message");
            return;
        }
        String s = StringUtils.trimToNull((String)data.toString());
        if (s == null) {
            Logger.warn((String)"no message data given, ignoring message");
            return;
        }
        File file = new File(s);
        ScriptingService service = (ScriptingService)Application.getBootLoader().getBootable(ScriptingService.class);
        if (!service.contains(file)) {
            Logger.debug((String)(file + " not registered"));
            return;
        }
        service.removeScript(file);
    }

    @Override
    public boolean autoRegister() {
        return false;
    }
}

