/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.util.Popup;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.TextMessage;
import de.willuhn.jameica.system.Application;
import org.apache.commons.lang.StringUtils;

public class PopupMessageConsumer
implements MessageConsumer {
    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{TextMessage.class, QueryMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        Message msg;
        String s1 = null;
        String s2 = null;
        if (message instanceof TextMessage) {
            msg = (TextMessage)message;
            s1 = ((TextMessage)msg).getTitle();
            s2 = ((TextMessage)msg).getText();
        } else if (message instanceof QueryMessage) {
            msg = (QueryMessage)message;
            s1 = ((QueryMessage)msg).getName();
            s2 = ((QueryMessage)msg).getData() != null ? ((QueryMessage)msg).getData().toString() : null;
        } else {
            s2 = message.toString();
        }
        final String title = StringUtils.trimToEmpty((String)s1);
        final String text = StringUtils.trimToEmpty((String)s2);
        if (Application.inServerMode()) {
            Object s = title;
            if (text.length() > 0) {
                s = (String)s + "\n" + text;
            }
            Application.getCallback().notifyUser((String)s);
            return;
        }
        GUI.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Popup popup = new Popup(title, text);
                popup.setTimeout(10);
                popup.open();
            }
        });
    }

    @Override
    public boolean autoRegister() {
        return false;
    }
}

