/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.io.FileFinder;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.PluginMessage;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.services.ScriptingService;
import de.willuhn.jameica.system.Application;
import java.io.File;
import java.util.List;

public class PluginUninstallScriptingMessageConsumer
implements MessageConsumer {
    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{PluginMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        PluginMessage msg = (PluginMessage)message;
        PluginMessage.Event e = msg.getEvent();
        if (e == null || e != PluginMessage.Event.UNINSTALLED) {
            return;
        }
        File dir = new File(msg.getManifest().getPluginDir());
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        FileFinder finder = new FileFinder(dir);
        finder.extension(".js");
        File[] matches = finder.findRecursive();
        ScriptingService service = (ScriptingService)Application.getBootLoader().getBootable(ScriptingService.class);
        List<File> scripts = service.getScripts();
        for (File f : matches) {
            if (!scripts.contains(f)) continue;
            Application.getMessagingFactory().getMessagingQueue("jameica.scripting.remove").sendMessage(new QueryMessage(f));
        }
    }

    @Override
    public boolean autoRegister() {
        return true;
    }
}

