/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.PluginMessage;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PluginCacheMessageConsumer
implements MessageConsumer {
    private static Map<String, Manifest> cache = null;

    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{PluginMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        PluginMessage m = (PluginMessage)message;
        Manifest mf = m.getManifest();
        PluginMessage.Event event = m.getEvent();
        switch (event) {
            case INSTALLED: 
            case UPDATED: {
                PluginCacheMessageConsumer.getCache().put(mf.getName(), mf);
                break;
            }
            case UNINSTALLED: {
                PluginCacheMessageConsumer.getCache().remove(mf.getName());
                break;
            }
            default: {
                Logger.warn((String)("unknown event " + event));
            }
        }
    }

    @Override
    public boolean autoRegister() {
        return true;
    }

    public static synchronized Map<String, Manifest> getCache() {
        if (cache == null) {
            cache = new LinkedHashMap<String, Manifest>();
            List<Manifest> mfs = Application.getPluginLoader().getManifests();
            for (Manifest m : mfs) {
                cache.put(m.getName(), m);
            }
        }
        return cache;
    }
}

