/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingFactory;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.plugin.ConsumerDescriptor;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.MessageDescriptor;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.MultipleClassLoader;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;

public class ManifestMessageConsumer
implements MessageConsumer {
    private static boolean done = false;

    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{SystemMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        if (done) {
            return;
        }
        SystemMessage msg = (SystemMessage)message;
        if (msg.getStatusCode() != 1) {
            return;
        }
        this.registerConsumers();
        this.sendMessages();
    }

    private void registerConsumers() {
        Logger.debug((String)"searching for message consumers from manifests");
        MessagingFactory factory = Application.getMessagingFactory();
        BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        LinkedList<Manifest> list = new LinkedList<Manifest>();
        list.addAll(Application.getPluginLoader().getInstalledManifests());
        list.add(Application.getManifest());
        int count = 0;
        for (Manifest mf : list) {
            ConsumerDescriptor[] consumers = mf.getMessageConsumers();
            if (consumers == null || consumers.length == 0) continue;
            for (ConsumerDescriptor d : consumers) {
                String classname = d.getClassname();
                String queue = d.getQueue();
                if (classname == null || classname.length() == 0) {
                    Logger.warn((String)("skipping consumer declaration in manifest from " + mf.getName() + ", contains no class name"));
                    continue;
                }
                try {
                    Class c = null;
                    if (mf.isSystemManifest()) {
                        c = Application.getClassLoader().load(classname);
                    } else {
                        MultipleClassLoader loader = mf.getClassLoader();
                        c = loader.load(classname);
                    }
                    MessageConsumer mc = (MessageConsumer)beanService.get(c);
                    if (mc.autoRegister()) continue;
                    if (StringUtils.trimToNull((String)queue) != null) {
                        Logger.debug((String)("  " + queue + ": " + classname));
                        factory.getMessagingQueue(queue).registerMessageConsumer(mc);
                    } else {
                        Logger.debug((String)("  <default-queue>: " + classname));
                        factory.registerMessageConsumer(mc);
                    }
                    ++count;
                }
                catch (Throwable t) {
                    Logger.error((String)("unable to register message consumer " + classname), (Throwable)t);
                }
            }
        }
        Logger.info((String)("message consumers from manifests: " + count));
    }

    private void sendMessages() {
        Logger.debug((String)"searching for messages from manifests");
        MessagingFactory factory = Application.getMessagingFactory();
        LinkedList<Manifest> list = new LinkedList<Manifest>();
        list.addAll(Application.getPluginLoader().getInstalledManifests());
        list.add(Application.getManifest());
        int count = 0;
        for (Manifest mf : list) {
            MessageDescriptor[] messages = mf.getMessages();
            if (messages == null || messages.length == 0) continue;
            for (MessageDescriptor d : messages) {
                String queue = d.getQueue();
                String data = d.getData();
                if (queue == null || queue.length() == 0) {
                    Logger.warn((String)("skipping message in manifest from " + mf.getName() + ", contains no queue name"));
                    continue;
                }
                if (data == null || data.length() == 0) {
                    Logger.warn((String)("skipping message in manifest from " + mf.getName() + ", contains no data"));
                    continue;
                }
                factory.getMessagingQueue(queue).sendMessage(new QueryMessage(data));
            }
        }
        Logger.info((String)("messages from manifests: " + count));
    }

    @Override
    public boolean autoRegister() {
        return false;
    }
}

