/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.net.MulticastClient;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Hashtable;

public class LookupService
implements MessageConsumer {
    private static Hashtable<String, String> lookup = new Hashtable();
    private static Client client = null;

    public static void register(String name, String url) {
        if (LookupService.enabled()) {
            Logger.info((String)("register multicast lookup. name: " + name + ", url: " + url));
            lookup.put(name, url);
        }
    }

    public static void unRegister(String name) {
        if (LookupService.enabled()) {
            Logger.info((String)("un-register lookup name: " + name));
            lookup.remove(name);
        }
    }

    private static boolean enabled() {
        return Application.inServerMode() && Application.getConfig().getMulticastLookup();
    }

    @Override
    public boolean autoRegister() {
        return LookupService.enabled();
    }

    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{SystemMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        if (!LookupService.enabled()) {
            return;
        }
        if (message == null || !(message instanceof SystemMessage)) {
            return;
        }
        SystemMessage msg = (SystemMessage)message;
        if (msg.getStatusCode() == 1) {
            if (lookup.size() == 0) {
                Logger.debug((String)"no lookup urls registered, skip multicast lookup");
                return;
            }
            client = new Client();
            Logger.info((String)"multicast lookup service started");
        }
        if (msg.getStatusCode() == 2 && client != null) {
            Logger.info((String)"stop multicast lookup client");
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String lookup(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        Logger.info((String)("performing multicast lookup for service name: " + name));
        ServerLookup s = null;
        try {
            s = new ServerLookup(name);
            s.send();
            long started = System.currentTimeMillis();
            while (System.currentTimeMillis() - started < 5000L && s.url == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (s.url != null) {
                Logger.info((String)("found server for service name: " + name + " - url: " + s.url));
                String string = s.url;
                return string;
            }
        }
        catch (Exception e) {
            Logger.write((Level)Level.DEBUG, (String)"multicast lookup failed, stacktrace for debugging purpose", (Throwable)e);
            Logger.info((String)("multicast lookup not possible: " + e.getMessage()));
        }
        finally {
            if (s != null) {
                try {
                    s.stop();
                }
                catch (Exception exception) {}
            }
        }
        Logger.info((String)("no server found for service name: " + name));
        return null;
    }

    private class Client
    extends MulticastClient {
        public void received(DatagramPacket packet) throws IOException {
            InetAddress sender = packet.getAddress();
            InetAddress self = InetAddress.getLocalHost();
            Logger.debug((String)("got datagram packet from " + sender.getHostName()));
            if (sender.equals(self)) {
                return;
            }
            String s = new String(packet.getData());
            if (s.length() == 0) {
                Logger.debug((String)"ignoring empty message");
                return;
            }
            if ((s = s.trim()).matches("[^a-zA-Z\\.]")) {
                Logger.debug((String)("ignoring message: " + s));
                return;
            }
            String url = lookup.get(s);
            if (url == null) {
                Logger.debug((String)("service " + s + " not found on this system, ignoring"));
                return;
            }
            Logger.info((String)("got lookup request for service " + s + " from " + sender.getCanonicalHostName()));
            Logger.info((String)("sending url: " + url));
            this.send(url.getBytes());
        }
    }

    private static class ServerLookup
    extends MulticastClient {
        private String name = null;
        private String url = null;

        public ServerLookup(String name) throws IOException {
            this.name = name;
        }

        public void send() throws IOException {
            super.send(this.name.getBytes());
        }

        public void received(DatagramPacket packet) throws IOException {
            InetAddress self;
            InetAddress sender = packet.getAddress();
            if (sender.equals(self = InetAddress.getLocalHost())) {
                return;
            }
            String s = new String(packet.getData());
            if (s.length() == 0) {
                return;
            }
            if ((s = s.trim()).equals(this.name)) {
                return;
            }
            this.url = s;
            Logger.info((String)("got answer from " + sender.getCanonicalHostName() + ", url: " + this.url));
            Thread.currentThread().interrupt();
        }
    }
}

