/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.services.ScriptingService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;

public class InvokeScriptMessageConsumer
implements MessageConsumer {
    private static final I18N i18n = Application.getI18n();
    private static final String PREFIX_FX = "function.";

    @Override
    public boolean autoRegister() {
        return false;
    }

    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{QueryMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        if (!(message instanceof QueryMessage)) {
            return;
        }
        QueryMessage msg = (QueryMessage)message;
        ScriptingService service = (ScriptingService)Application.getBootLoader().getBootable(ScriptingService.class);
        ScriptEngine engine = service.getEngine();
        if (engine == null) {
            msg.setData((Object)new ApplicationException(i18n.tr("Die installierte Java-Version enth\u00e4lt keine JavaScript-Unterst\u00fctzung (RhinoScript)")));
            return;
        }
        String event = msg.getName();
        if (event == null || event.length() == 0) {
            Logger.warn((String)"no event name given for script execution");
            msg.setData((Object)new ApplicationException(i18n.tr("Kein Event-Name angegeben")));
            return;
        }
        List<String> functions = null;
        if (event.startsWith(PREFIX_FX) && event.length() > PREFIX_FX.length()) {
            functions = new ArrayList<String>();
            functions.add(event.substring(PREFIX_FX.length()));
        } else {
            functions = service.getFunction(event);
        }
        if (functions == null || functions.size() == 0) {
            Logger.debug((String)("no script functions registered for event " + event));
            msg.setData((Object)new ApplicationException(i18n.tr("Kein passendes Script gefunden")));
            return;
        }
        ArrayList<Object> returns = new ArrayList<Object>();
        Invocable i = (Invocable)((Object)engine);
        Object params = msg.getData();
        for (String method : functions) {
            try {
                Object value = null;
                value = params != null && params.getClass().isArray() ? i.invokeFunction(method, (Object[])params) : i.invokeFunction(method, params);
                if (value == null) continue;
                returns.add(value);
            }
            catch (NoSuchMethodException nme) {
                Logger.debug((String)("script method not found: " + method));
                returns.add((Object)new ApplicationException(i18n.tr("Funktion nicht in Script gefunden")));
            }
            catch (Exception e) {
                Logger.error((String)("error while executing script method " + method + ", adding exception to return list"), (Throwable)e);
                returns.add(e);
            }
        }
        if (returns.size() == 0) {
            msg.setData(null);
        } else if (returns.size() == 1) {
            msg.setData(returns.get(0));
        } else {
            msg.setData(returns);
        }
    }
}

