/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.MessagingFactory;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;

public class AutoRegisterMessageConsumer
implements MessageConsumer {
    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{SystemMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        SystemMessage msg = (SystemMessage)message;
        if (msg.getStatusCode() != 1) {
            return;
        }
        Logger.debug((String)"searching for auto-registered message consumers");
        MessagingFactory factory = Application.getMessagingFactory();
        BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        Class[] c = new Class[]{};
        try {
            c = Application.getClassLoader().getClassFinder().findImplementors(MessageConsumer.class);
        }
        catch (ClassNotFoundException e) {
            Logger.info((String)"  no messaging consumers found");
            return;
        }
        int count = 0;
        for (int i = 0; i < c.length; ++i) {
            try {
                MessageConsumer mc = (MessageConsumer)beanService.get(c[i]);
                if (!mc.autoRegister()) continue;
                Logger.debug((String)("  " + c[i].getName()));
                factory.registerMessageConsumer(mc);
                ++count;
                continue;
            }
            catch (Throwable t) {
                Logger.error((String)("unable to register message consumer " + c[i].getName()), (Throwable)t);
            }
        }
        Logger.info((String)("auto-registered message consumers: " + count));
    }

    @Override
    public boolean autoRegister() {
        return false;
    }
}

