/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.util;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.Session;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SWTUtil {
    private static Integer zoom = null;
    private static Session imagecache = new Session();

    public static void disposeChildren(Composite c) {
        if (c == null || c.isDisposed()) {
            return;
        }
        try {
            Control[] children = c.getChildren();
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                if (children[i] instanceof Composite) {
                    SWTUtil.disposeChildren((Composite)children[i]);
                }
                if (children[i] == null || children[i].isDisposed()) continue;
                children[i].dispose();
            }
        }
        catch (Throwable t) {
            Logger.error((String)"error while disposing composite children", (Throwable)t);
        }
    }

    public static Image getImage(String filename) {
        return SWTUtil.getImage(filename, (ClassLoader)Application.getClassLoader());
    }

    public static int getDeviceZoom() {
        if (zoom != null) {
            return zoom;
        }
        String swtZoom = System.getProperty("org.eclipse.swt.internal.deviceZoom");
        zoom = 100;
        String value = null;
        try {
            value = Customizing.SETTINGS.getString("application.zoom", swtZoom);
            if (value != null && value.length() > 0) {
                zoom = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            Logger.error((String)("invalid device zoom factor: " + value));
        }
        Logger.info((String)("application zoom: " + zoom + ", swt zoom: " + swtZoom));
        return zoom;
    }

    public static Image getImage(String filename, ClassLoader cl) {
        Image image = (Image)imagecache.get((Object)filename);
        if (image != null && !image.isDisposed()) {
            return image;
        }
        image = SWTUtil.getZoomedImage(filename, cl);
        if (image != null) {
            imagecache.put((Object)filename, (Object)image);
        }
        return image;
    }

    private static Image getZoomedImage(final String filename, final ClassLoader cl) {
        final int imageZoom = Customizing.SETTINGS.getInt("application.zoom.image", 0);
        ImageDataProvider provider = new ImageDataProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ImageData getImageData(int z) {
                ImageData imageData;
                InputStream is;
                block6: {
                    int zoom = imageZoom > 0 ? imageZoom : z;
                    is = null;
                    try {
                        if (!Customizing.SETTINGS.getBoolean("application.zoom.enabled", true)) {
                            is = SWTUtil.getStream(filename, cl, null);
                        } else {
                            ZoomLevel l;
                            imageData = ZoomLevel.values();
                            int n = ((ZoomLevel[])imageData).length;
                            for (int i = 0; !(i >= n || (l = imageData[i]).matches(zoom) && (is = SWTUtil.getStream(filename, cl, l)) != null); ++i) {
                            }
                        }
                        if (is == null) break block6;
                        imageData = new ImageData(is);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                    IOUtil.close((Closeable[])new Closeable[]{is});
                    return imageData;
                }
                imageData = new ImageData(Application.getClassLoader().getResourceAsStream("img/empty.gif"));
                IOUtil.close((Closeable[])new Closeable[]{is});
                return imageData;
            }
        };
        try {
            return new Image((Device)GUI.getDisplay(), provider);
        }
        catch (Throwable t) {
            Logger.error((String)"unable to load image", (Throwable)t);
            return new Image((Device)GUI.getDisplay(), Application.getClassLoader().getResourceAsStream("img/empty.gif"));
        }
    }

    public static Image getImage(InputStream is) {
        Image image = null;
        if (is != null) {
            try {
                ImageData data = new ImageData(is);
                ImageData data2 = null;
                if (data.transparentPixel > 0) {
                    data2 = data.getTransparencyMask();
                    image = new Image((Device)GUI.getDisplay(), data, data2);
                } else {
                    image = new Image((Device)GUI.getDisplay(), data);
                }
                return image;
            }
            catch (Throwable t) {
                Logger.error((String)"unable to load image", (Throwable)t);
            }
        }
        return new Image((Device)GUI.getDisplay(), Application.getClassLoader().getResourceAsStream("img/empty.gif"));
    }

    private static InputStream getStream(String filename, ClassLoader cl, ZoomLevel zoom) {
        Object sub2;
        InputStream is = null;
        String path = zoom != null ? zoom.getPath() : null;
        try {
            sub2 = path != null ? path + "/" : "";
            is = cl.getResourceAsStream("img/" + (String)sub2 + filename);
        }
        catch (Exception sub2) {
            // empty catch block
        }
        if (is == null) {
            try {
                sub2 = path != null ? path + File.separator : "";
                File file = new File((String)sub2 + filename);
                if (file.isFile() && file.canRead()) {
                    is = new BufferedInputStream(new FileInputStream(file));
                }
            }
            catch (Exception e2) {
                Logger.error((String)("unable to load image from " + filename), (Throwable)e2);
            }
        }
        return is;
    }

    public static Canvas getCanvas(final Composite parent, final Image image, final int align) {
        final Rectangle i = image.getBounds();
        GridData gd = new GridData(768);
        gd.heightHint = i.height;
        Canvas canvas = new Canvas(parent, 0);
        canvas.setLayoutData((Object)gd);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    Rectangle r = parent.getBounds();
                    if ((align & 0x80) != 0 && (align & 0x400) != 0) {
                        e.gc.drawImage(image, 0, 0, i.width, i.height, 0, 0, i.width, r.height);
                    } else if ((align & 0x4000) != 0 && (align & 0x20000) != 0) {
                        e.gc.drawImage(image, 0, 0, i.width, i.height, 0, 0, r.width, i.height);
                    } else {
                        int x = 0;
                        int y = 0;
                        if ((align & 0x400) != 0) {
                            y = r.height - i.height;
                        }
                        if ((align & 0x20000) != 0) {
                            x = r.width - i.width;
                        }
                        e.gc.drawImage(image, x, y);
                    }
                }
                catch (IllegalArgumentException ex) {
                    Logger.write((Level)Level.DEBUG, (String)("unable to draw image " + image + " (" + i + ") on canvas"), (Throwable)ex);
                }
            }
        });
        return canvas;
    }

    public static GridLayout createGrid(int numColumns, boolean makeEqualsWidth) {
        GridLayout l = new GridLayout(numColumns, makeEqualsWidth);
        l.marginWidth = 0;
        l.marginHeight = 0;
        l.horizontalSpacing = 0;
        l.verticalSpacing = 0;
        return l;
    }

    public static final int getDPI() {
        final AtomicInteger ai = new AtomicInteger();
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Point dpi = GUI.getDisplay().getDPI();
                int pixel = dpi != null ? dpi.y : -1;
                ai.set(pixel);
            }
        });
        int value = ai.get();
        if (value < 60 || value > 600) {
            Logger.warn((String)("DPI size " + value + " not plausible, DPI size will be ignored"));
            value = -1;
        }
        return Customizing.SETTINGS.getInt("application.dpi", value);
    }

    public static final int pt2px(int pt) {
        try {
            int pixel = SWTUtil.getDPI();
            if (pixel == -1) {
                return -1;
            }
            double i = (double)pixel / 72.0;
            return (int)((double)pt * i);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public static final int scaledPx(int px) {
        int zoom = SWTUtil.getDeviceZoom();
        if (zoom == 100) {
            return px;
        }
        float scale = (float)zoom / 100.0f;
        return Math.round((float)px * scale);
    }

    public static final int mm2px(int mm) {
        try {
            int pixel = SWTUtil.getDPI();
            if (pixel == -1) {
                return -1;
            }
            double millis = 25.4;
            double inches = (double)mm / millis;
            return (int)((double)pixel * inches);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public static final String escapeLabel(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        text = text.replaceAll("&", "&&");
        return text;
    }

    public static KeyStroke getKeyStroke(String shortcut) {
        if ((shortcut = StringUtils.trimToNull((String)shortcut)) == null) {
            return null;
        }
        try {
            KeyStroke stroke = KeyStroke.getInstance((String)shortcut);
            return stroke.isComplete() ? stroke : null;
        }
        catch (Exception e) {
            Logger.error((String)("unable to parse shortcut " + shortcut), (Throwable)e);
            return null;
        }
    }

    public static enum ZoomLevel {
        ZOOM_300(300, 250, "300"),
        ZOOM_200(200, 175, "200"),
        ZOOM_150(150, 125, "150"),
        ZOOM_100(100, 0, null);

        private int level;
        private int start;
        private String path;

        private ZoomLevel(int level, int start, String path) {
            this.level = level;
            this.start = start;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        private boolean matches(int zoom) {
            return zoom >= this.start;
        }

        public int getLevel() {
            return this.level;
        }

        public static ZoomLevel max() {
            return ZoomLevel.values()[0];
        }
    }
}

