/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.util;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Popup {
    private static final int ALIGN_DEFAULT = 132096;
    private static final int ALPHA = 180;
    private Shell shell = null;
    private String title = null;
    private String text = null;
    private Point location = null;
    private int align = 132096;
    private int timeout = -1;
    private org.eclipse.swt.graphics.Color bg = null;
    private org.eclipse.swt.graphics.Color fg = null;

    public Popup(String text) {
        this(null, text);
    }

    public Popup(String title, String text) {
        this(title, text, null);
    }

    public Popup(String title, String text, Point location) {
        this(title, text, location, 132096);
    }

    public Popup(String title, String text, Point location, int align) {
        this.title = title;
        this.text = text;
        this.location = location;
        this.align = align;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void open() {
        if (this.shell != null) {
            this.close();
        }
        Display display = GUI.getDisplay();
        this.bg = display.getSystemColor(29);
        this.fg = display.getSystemColor(28);
        if (this.bg == null || this.fg == null || this.bg.equals((Object)this.fg)) {
            this.bg = Color.TOOLTIP_BG.getSWTColor();
            this.fg = Color.BLACK.getSWTColor();
        }
        this.shell = new Shell(GUI.getShell(), 16388);
        this.shell.setAlpha(180);
        if (this.bg != null) {
            this.shell.setBackground(this.bg);
        }
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 5;
        gl.verticalSpacing = 5;
        this.shell.setLayout((Layout)gl);
        Composite comp = new Composite((Composite)this.shell, 0);
        comp.setLayoutData((Object)new GridData(32));
        if (this.bg != null) {
            comp.setBackground(this.bg);
        }
        comp.setBackgroundMode(2);
        this.paint(comp);
        Button ok = new Button((Composite)this.shell, 2048);
        ok.setLayoutData((Object)new GridData(3));
        if (this.bg != null) {
            ok.setBackground(this.bg);
        }
        ok.setText("  OK  ");
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Popup.this.close();
            }
        });
        if (this.location == null) {
            Rectangle r = GUI.getShell().getBounds();
            this.location = new Point(r.x + r.width, r.y + r.height);
            this.align = 132096;
        }
        Point size = this.shell.computeSize(-1, -1);
        if ((this.align & 0x20000) != 0) {
            this.location.x -= size.x;
        }
        if ((this.align & 0x400) != 0) {
            this.location.y -= size.y;
        }
        this.shell.setBounds(this.location.x, this.location.y, size.x, size.y);
        this.shell.setVisible(true);
        if (this.timeout > 0) {
            display.timerExec(this.timeout * 1000, new Runnable(){

                @Override
                public void run() {
                    Popup.this.close();
                }
            });
        }
    }

    public void close() {
        try {
            if (this.shell == null || this.shell.isDisposed()) {
                return;
            }
            SWTUtil.disposeChildren((Composite)this.shell);
            this.shell.close();
            if (!this.shell.isDisposed()) {
                this.shell.dispose();
            }
        }
        catch (Exception e2) {
            Logger.error((String)"error while disposing popup", (Throwable)e2);
        }
    }

    protected void paint(Composite comp) {
        Label label;
        comp.setLayout((Layout)new RowLayout(512));
        if (this.title != null && this.title.length() > 0) {
            label = new Label(comp, 0);
            label.setLayoutData((Object)new RowData());
            label.setFont(Font.BOLD.getSWTFont());
            if (this.fg != null) {
                label.setForeground(this.fg);
            }
            if (this.bg != null) {
                label.setBackground(this.bg);
            }
            label.setText(this.title);
        }
        label = new Label(comp, 0);
        label.setLayoutData((Object)new RowData());
        if (this.fg != null) {
            label.setForeground(this.fg);
        }
        if (this.bg != null) {
            label.setBackground(this.bg);
        }
        label.setText(this.text == null ? "" : this.text);
    }
}

