/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.util;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.system.Application;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DelayedListener
implements Listener {
    private static final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    public static final int TIMEOUT_DEFAULT = 300;
    private AtomicInteger count = new AtomicInteger();
    private int timeout = 300;
    private Listener listener = null;

    public DelayedListener(Listener listener) {
        this(300, listener);
    }

    public DelayedListener(int millis, Listener listener) {
        this.timeout = millis;
        this.listener = listener;
    }

    public final synchronized void handleEvent(final Event event) {
        final int myCount = this.count.incrementAndGet();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (myCount < DelayedListener.this.count.get()) {
                    return;
                }
                if (Application.inServerMode()) {
                    DelayedListener.this.listener.handleEvent(event);
                } else {
                    GUI.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DelayedListener.this.listener.handleEvent(event);
                        }
                    });
                }
            }
        };
        executorService.schedule(r, (long)this.timeout, TimeUnit.MILLISECONDS);
    }
}

