/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts.table;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.parts.ContextMenu;
import de.willuhn.jameica.gui.parts.ContextMenuItem;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FeatureShortcut
implements Feature {
    private List<Listener> shortcuts = new ArrayList<Listener>();
    private boolean applied = false;

    @Override
    public boolean onEvent(Feature.Event e) {
        return e == Feature.Event.PAINT;
    }

    @Override
    public void handleEvent(Feature.Event e, Feature.Context ctx) {
        if (this.applied) {
            return;
        }
        if (ctx.control == null || ctx.menu == null) {
            return;
        }
        this.applied = true;
        this.applyShortcuts(ctx, ctx.menu.getItems());
        ctx.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Listener l : FeatureShortcut.this.shortcuts) {
                    GUI.getDisplay().removeFilter(2, l);
                    Logger.debug((String)("unbound " + l));
                }
            }
        });
    }

    private void applyShortcuts(final Feature.Context ctx, List items) {
        for (Object o : items) {
            KeyStroke shortcut;
            Action action;
            ContextMenuItem i;
            if (o instanceof ContextMenu) {
                this.applyShortcuts(ctx, ((ContextMenu)o).getItems());
                continue;
            }
            if (!(o instanceof ContextMenuItem) || (i = (ContextMenuItem)o).isSeparator() || (action = i.getAction()) == null || (shortcut = SWTUtil.getKeyStroke(i.getShortcut())) == null) continue;
            try {
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        char c = (char)shortcut.getNaturalKey();
                        if (Character.isLetter(c)) {
                            c = Character.toLowerCase(c);
                        }
                        if (event.stateMask == shortcut.getModifierKeys() && event.keyCode == c) {
                            Object selection = ctx.part.getSelection();
                            if (selection == null) {
                                return;
                            }
                            if (i.isEnabledFor(selection)) {
                                try {
                                    action.handleAction(selection);
                                }
                                catch (ApplicationException e) {
                                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(e.getMessage(), 1));
                                }
                            }
                        }
                    }

                    public String toString() {
                        return shortcut.format() + ": " + action.getClass().getName();
                    }
                };
                GUI.getDisplay().addFilter(2, listener);
                this.shortcuts.add(listener);
                Logger.debug((String)("bound " + listener));
            }
            catch (Exception e) {
                Logger.error((String)("unable to parse shortcut " + shortcut), (Throwable)e);
            }
        }
    }
}

