/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts.table;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class FeatureClipboard
implements Feature {
    private static final Settings settings = new Settings(FeatureClipboard.class);
    private Listener listener = null;

    @Override
    public boolean onEvent(Feature.Event e) {
        return e == Feature.Event.PAINT;
    }

    @Override
    public void handleEvent(Feature.Event e, Feature.Context ctx) {
        if (this.listener != null) {
            return;
        }
        if (ctx.control == null) {
            return;
        }
        this.applyShortcut(ctx);
        ctx.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GUI.getDisplay().removeFilter(2, FeatureClipboard.this.listener);
                Logger.debug((String)("unbound " + FeatureClipboard.this.listener));
            }
        });
    }

    protected void applyShortcut(final Feature.Context ctx) {
        final String nl = settings.getString("line.separator", System.getProperty("line.separator", "\n"));
        final String sep = settings.getString("col.separator", ";");
        final String quote = settings.getString("quote.char", "\"");
        final KeyStroke shortcut = SWTUtil.getKeyStroke(settings.getString("shortcut", "CTRL+C"));
        if (shortcut == null) {
            return;
        }
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                char c = (char)shortcut.getNaturalKey();
                if (Character.isLetter(c)) {
                    c = Character.toLowerCase(c);
                }
                if (event.stateMask == shortcut.getModifierKeys() && event.keyCode == c) {
                    TableItem[] rows;
                    Table t;
                    Control control = ctx.control;
                    if (ctx.control.isDisposed()) {
                        return;
                    }
                    if (!ctx.control.isFocusControl()) {
                        return;
                    }
                    if (!(control instanceof Table) && !(control instanceof Tree)) {
                        return;
                    }
                    Widget widget = event.widget;
                    if (!(widget instanceof Table) && !(widget instanceof Tree)) {
                        return;
                    }
                    StringBuilder sb = new StringBuilder();
                    int colCount = 0;
                    int rowCount = 0;
                    if (control instanceof Table) {
                        t = (Table)control;
                        colCount = t.getColumnCount();
                        rows = t.getSelection();
                        if (rows == null || rows.length == 0) {
                            return;
                        }
                        rowCount = rows.length;
                        for (TableItem row : rows) {
                            for (int i = 0; i < colCount; ++i) {
                                String s = row.getText(i);
                                sb.append(quote);
                                sb.append(s != null ? s : "");
                                sb.append(quote);
                                if (i + 1 >= colCount) continue;
                                sb.append(sep);
                            }
                            sb.append(nl);
                        }
                    } else {
                        t = (Tree)control;
                        colCount = t.getColumnCount();
                        rows = t.getSelection();
                        if (rows == null || rows.length == 0) {
                            return;
                        }
                        rowCount = rows.length;
                        for (TableItem row : rows) {
                            for (int i = 0; i < colCount; ++i) {
                                String s = row.getText(i);
                                sb.append(quote);
                                sb.append(s != null ? s : "");
                                sb.append(quote);
                                if (i + 1 >= colCount) continue;
                                sb.append(sep);
                            }
                            sb.append(nl);
                        }
                    }
                    Clipboard clipboard = new Clipboard(GUI.getDisplay());
                    TextTransfer transfer = TextTransfer.getInstance();
                    clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{transfer});
                    clipboard.dispose();
                    Logger.info((String)("copied text to clipboard. cols: " + colCount + ", rows: " + rowCount));
                    if (rowCount > 1) {
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("{0} Zeilen in Zwischenablage kopiert", Integer.toString(rowCount)), 2));
                    } else {
                        Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Eine Zeile in Zwischenablage kopiert"), 2));
                    }
                }
            }
        };
        GUI.getDisplay().addFilter(2, this.listener);
        Logger.debug((String)("bound " + this.listener));
    }
}

