/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.formatter.TreeFormatter;
import de.willuhn.jameica.gui.parts.AbstractTablePart;
import de.willuhn.jameica.gui.parts.Column;
import de.willuhn.jameica.gui.parts.table.Feature;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.logging.Logger;
import de.willuhn.security.Checksum;
import de.willuhn.util.Session;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreePart
extends AbstractTablePart {
    private static final String IMG_FOLDER_OPEN = Customizing.SETTINGS.getString("application.tree.icon.folderopen", "folder-open.png");
    private static final String IMG_FOLDER_CLOSE = Customizing.SETTINGS.getString("application.tree.icon.folderclose", "folder.png");
    private static final String IMG_DEFAULT = Customizing.SETTINGS.getString("application.tree.icon.default", "text-x-generic.png");
    private static final String IMG_SORT_UP = Customizing.SETTINGS.getString("application.sort.icon.up", "up.png");
    private static final String IMG_SORT_DOWN = Customizing.SETTINGS.getString("application.sort.icon.down", "down.png");
    private TreeFormatter formatter = null;
    private List list = null;
    private Tree tree = null;
    private String id = null;
    private boolean expanded = true;
    private Map<Object, Item> itemLookup = new HashMap<Object, Item>();
    private Map<TreeItem, Boolean> autoimage = new HashMap<TreeItem, Boolean>();
    private static Session state = new Session();
    private Image up = SWTUtil.getImage(IMG_SORT_UP);
    private Image down = SWTUtil.getImage(IMG_SORT_DOWN);
    private int sortedBy = -1;
    private boolean direction = true;

    public TreePart(Object object, Action action) {
        super(action);
        this.setRootObject(object);
    }

    public TreePart(GenericIterator list, Action action) {
        super(action);
        this.setList(list);
    }

    public TreePart(List list, Action action) {
        super(action);
        this.setList(list);
    }

    @Override
    protected Feature.Context createFeatureEventContext(Feature.Event e, Object data) {
        Feature.Context ctx = super.createFeatureEventContext(e, data);
        ctx.control = this.tree;
        return ctx;
    }

    public void setList(GenericIterator list) {
        this.setList(TreePart.asList(list));
    }

    public void setList(List list) {
        this.removeAll();
        try {
            this.list = list;
            this.loadData();
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to apply list", (Throwable)re);
        }
    }

    public void setRootObject(Object node) {
        this.setList(node != null ? Arrays.asList(node) : null);
    }

    public void setFormatter(TreeFormatter formatter) {
        this.formatter = formatter;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    String getID() throws Exception {
        if (this.id != null) {
            return this.id;
        }
        StringBuffer sb = new StringBuffer();
        if (this.list != null && this.list.size() > 0) {
            sb.append(this.list.get(0).getClass().getName());
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Column col = (Column)this.columns.get(i);
            sb.append(col.getColumnId());
        }
        String s = sb.toString();
        if (s == null || s.length() == 0) {
            s = "unknown";
        }
        this.id = Checksum.md5((byte[])s.getBytes());
        return this.id;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        Object col;
        int i;
        this.tree = new Tree(parent, 0x10800 | (this.multi ? 2 : 4) | (this.checkable ? 32 : 0));
        this.tree.setFont(Font.DEFAULT.getSWTFont());
        GridData gridData = new GridData(1808);
        this.tree.setLayoutData((Object)gridData);
        this.tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreePart.this.handleFolderOpen(event);
            }
        });
        this.tree.addListener(18, new Listener(){

            public void handleEvent(Event event) {
                TreePart.this.handleFolderClose(event);
            }
        });
        this.tree.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (!TreePart.this.tree.isFocusControl()) {
                    return;
                }
                Object o = TreePart.this.getSelection();
                if (o == null) {
                    return;
                }
                Item i = TreePart.this.itemLookup.get(o);
                if (i == null) {
                    return;
                }
                if (e.detail == 4) {
                    e.doit = false;
                    if (i.item.getItemCount() > 0) {
                        i.item.setExpanded(!i.item.getExpanded());
                    } else {
                        TreePart.this.open(TreePart.this.getSelection());
                    }
                } else if (e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                    e.doit = false;
                    if (i.item.getItemCount() == 0) {
                        return;
                    }
                    i.item.setExpanded(e.keyCode == 0x1000004);
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreePart.this.handleDoubleClick(e);
            }

            public void mouseDown(MouseEvent e) {
                TreePart.this.handleMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                TreePart.this.handleMouseUp(e);
            }
        });
        this.tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int listeners = TreePart.this.selectionListeners.size();
                if (listeners == 0 && TreePart.this.menu == null) {
                    return;
                }
                event.data = TreePart.this.getSelection();
                if (TreePart.this.menu != null) {
                    TreePart.this.menu.setCurrentObject(event.data);
                }
                if (listeners == 0) {
                    return;
                }
                if (TreePart.this.checkable && event.detail == 32) {
                    TreeItem[] items = TreePart.this.tree.getSelection();
                    if (items != null && items.length > 0) {
                        event.detail = items[0].getChecked() ? 1 : 0;
                    }
                } else {
                    event.detail = -1;
                }
                for (Listener l : TreePart.this.selectionListeners) {
                    try {
                        l.handleEvent(event);
                    }
                    catch (Throwable t) {
                        Logger.error((String)"error while executing listener, skipping", (Throwable)t);
                    }
                }
            }
        });
        if (this.columns.size() > 0) {
            int[] colOrder;
            this.tree.setHeaderVisible(true);
            this.tree.setLinesVisible(true);
            Object test = this.list != null && this.list.size() > 0 ? this.list.get(0) : null;
            i = 0;
            while (i < this.columns.size()) {
                Object value;
                col = (Column)this.columns.get(i);
                final TreeColumn tc = new TreeColumn(this.tree, 16384);
                ((Column)col).setColumn((org.eclipse.swt.widgets.Item)tc);
                tc.setMoveable(true);
                tc.setText(((Column)col).getName() == null ? "" : ((Column)col).getName());
                if (((Column)col).getAlign() != -1) {
                    tc.setAlignment(((Column)col).getAlign());
                } else if (test != null && (value = BeanUtil.get(test, (String)((Column)col).getColumnId())) instanceof Number) {
                    tc.setAlignment(131072);
                }
                if (this.rememberColWidth) {
                    final int index = i;
                    tc.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            try {
                                if (tc == null || tc.isDisposed()) {
                                    return;
                                }
                                AbstractTablePart.settings.setAttribute("width." + TreePart.this.getID() + "." + index, tc.getWidth());
                            }
                            catch (Exception ex) {
                                Logger.error((String)("unable to store width for column " + index), (Throwable)ex);
                            }
                        }
                    });
                }
                final int p = i++;
                tc.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        TreePart.this.direction = !TreePart.this.direction || p != TreePart.this.sortedBy;
                        TreePart.this.sortedBy = p;
                        TreePart.this.orderBy(p);
                    }
                });
            }
            if (this.rememberOrder && (colOrder = this.getColumnOrder()) != null) {
                this.tree.setColumnOrder(colOrder);
            }
            if (this.rememberOrder) {
                this.tree.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        try {
                            TreePart.this.setColumnOrder(TreePart.this.tree.getColumnOrder());
                        }
                        catch (Exception ex) {
                            Logger.error((String)"unable to store last order", (Throwable)ex);
                        }
                    }
                });
            }
            if (this.rememberState) {
                this.addSelectionListener(new Listener(){

                    public void handleEvent(Event event) {
                        try {
                            state.put((Object)TreePart.this.getID(), TreePart.this.getSelection());
                        }
                        catch (Exception ex) {
                            Logger.error((String)"unable to store state", (Throwable)ex);
                        }
                    }
                });
            }
        }
        if (this.menu != null) {
            this.menu.paint((Composite)this.tree);
        }
        this.loadData();
        int cols = this.tree.getColumnCount();
        for (i = 0; i < cols; ++i) {
            col = this.tree.getColumn(i);
            if (this.rememberColWidth) {
                int size = 0;
                try {
                    size = settings.getInt("width." + this.getID() + "." + i, 0);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to restore column width", (Throwable)e);
                }
                if (size <= 0) {
                    col.pack();
                    continue;
                }
                col.setWidth(size);
                continue;
            }
            col.pack();
        }
        this.restoreState();
        this.featureEvent(Feature.Event.PAINT, null);
    }

    private void orderBy(int index) {
        for (TreeColumn column : this.tree.getColumns()) {
            column.setImage(null);
        }
        this.tree.getColumn(index).setImage(this.direction ? this.down : this.up);
        Column sortColumn = (Column)this.columns.get(index);
        GenericTreeItemComparator comparator = new GenericTreeItemComparator(sortColumn, index);
        TreeItem[] items = this.tree.getItems();
        for (int i = 0; i < items.length; ++i) {
            this.orderBy(items[i], comparator);
        }
    }

    private void orderBy(TreeItem item, GenericTreeItemComparator comparator) {
        TreeItem[] children = item.getItems();
        ArrayList<TreeItem> itemsToSort = new ArrayList<TreeItem>();
        for (int i = 0; i < children.length; ++i) {
            TreeItem child = children[i];
            if (child.getItemCount() > 0) {
                this.orderBy(child, comparator);
                continue;
            }
            itemsToSort.add(child);
        }
        Collections.sort(itemsToSort, comparator);
        if (!this.direction) {
            Collections.reverse(itemsToSort);
        }
        for (TreeItem treeItemToReplace : itemsToSort) {
            Object data = treeItemToReplace.getData();
            treeItemToReplace.dispose();
            try {
                Item newItem = new Item(item, data);
                this.itemLookup.put(data, newItem);
            }
            catch (RemoteException e) {
                Logger.error((String)"error while sorting tree", (Throwable)e);
            }
        }
    }

    @Override
    public void restoreState() {
        if (!this.rememberState) {
            return;
        }
        try {
            Object selection = state.get((Object)this.getID());
            if (selection != null) {
                if (selection instanceof Object[]) {
                    this.select((Object[])selection);
                } else {
                    this.select(selection);
                }
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to restore state", (Throwable)e);
        }
    }

    private void loadData() throws RemoteException {
        if (this.list == null || this.tree == null || this.tree.isDisposed()) {
            return;
        }
        for (Object data : this.list) {
            Item i = new Item(null, data);
            this.itemLookup.put(data, i);
            this.setExpanded(data, this.expanded, true);
        }
    }

    public void setExpanded(Object object, boolean expanded) {
        this.setExpanded(object, expanded, false);
    }

    public void setExpanded(Object object, boolean expanded, boolean recursive) {
        Item i = this.itemLookup.get(object);
        if (i == null) {
            return;
        }
        this.setExpanded(i.item, expanded, recursive);
    }

    private void setExpanded(TreeItem item, boolean expanded, boolean recursive) {
        if (item == null || item.isDisposed()) {
            return;
        }
        item.setExpanded(expanded);
        if (!recursive) {
            return;
        }
        TreeItem[] children = item.getItems();
        if (children != null && children.length > 0) {
            for (int k = 0; k < children.length; ++k) {
                this.setExpanded(children[k], expanded, recursive);
            }
        }
    }

    private void handleFolderOpen(Event event) {
        Widget widget = event.item;
        if (!(widget instanceof TreeItem)) {
            return;
        }
        TreeItem item = (TreeItem)widget;
        if (this.autoimage.get(item) == null) {
            return;
        }
        item.setImage(SWTUtil.getImage(IMG_FOLDER_OPEN));
    }

    private void handleFolderClose(Event event) {
        Widget widget = event.item;
        if (!(widget instanceof TreeItem)) {
            return;
        }
        TreeItem item = (TreeItem)widget;
        if (this.autoimage.get(item) == null) {
            return;
        }
        item.setImage(SWTUtil.getImage(IMG_FOLDER_CLOSE));
    }

    @Override
    public Object getSelection() {
        if (this.tree == null || this.tree.isDisposed()) {
            return null;
        }
        TreeItem[] items = this.tree.getSelection();
        if (items == null || items.length == 0) {
            return null;
        }
        if (items.length == 1) {
            return items[0].getData();
        }
        Class<?> type = null;
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < items.length; ++i) {
            Object elem = items[i].getData();
            if (elem == null) continue;
            if (type == null) {
                type = elem.getClass();
            }
            data.add(elem);
        }
        try {
            Object[] array = (Object[])Array.newInstance(type, data.size());
            return data.toArray(array);
        }
        catch (Exception e) {
            Logger.debug((String)"unable to create type safe array, fallback to generic array");
            return data.toArray();
        }
    }

    @Override
    public void select(Object[] objects) {
        if (objects == null || objects.length == 0 || this.tree == null) {
            return;
        }
        if (!this.multi && objects.length > 1) {
            Logger.warn((String)"multi selection disabled but user wants to select more than one element, selecting only the first one");
            this.select(objects[0]);
            return;
        }
        try {
            LinkedList<TreeItem> selection = new LinkedList<TreeItem>();
            for (Object o : objects) {
                if (o == null) continue;
                for (Object go : this.itemLookup.keySet()) {
                    Item item;
                    if (!BeanUtil.equals((Object)go, (Object)o) || (item = this.itemLookup.get(go)) == null) continue;
                    selection.add(item.item);
                }
            }
            if (selection.size() > 0) {
                this.tree.setSelection(selection.toArray(new TreeItem[selection.size()]));
            }
            if (this.menu != null) {
                this.menu.setCurrentObject(objects != null && objects.length == 1 ? objects[0] : objects);
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while selecting tree items", (Throwable)e);
        }
    }

    protected void handleMouseDown(MouseEvent event) {
    }

    protected void handleMouseUp(MouseEvent event) {
    }

    protected void handleSingleClick(MouseEvent event) {
    }

    protected void handleDoubleClick(MouseEvent event) {
        if (this.action == null || event.button != 1) {
            return;
        }
        Object o = this.getSelection();
        if (o == null) {
            TreeItem widget = this.tree.getItem(new Point(event.x, event.y));
            if (!(widget instanceof TreeItem)) {
                return;
            }
            TreeItem item = widget;
            o = item.getData();
        }
        this.open(o);
    }

    protected List getChildren(Object o) {
        try {
            if (o instanceof GenericObjectNode) {
                GenericObjectNode node = (GenericObjectNode)o;
                GenericIterator children = node.getChildren();
                return children != null ? PseudoIterator.asList((GenericIterator)children) : null;
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to load list of child objects", (Throwable)re);
        }
        return null;
    }

    @Override
    public List getItems() throws RemoteException {
        TreeItem[] items;
        if (this.list == null) {
            return null;
        }
        if (this.tree == null || this.tree.isDisposed() || !this.checkable) {
            return new ArrayList(this.list);
        }
        ArrayList checkedList = new ArrayList();
        for (TreeItem item : items = this.tree.getItems()) {
            this.add(item, checkedList);
        }
        return checkedList;
    }

    @Override
    public void setChecked(Object[] objects, boolean checked) {
        if (objects == null || objects.length == 0 || !this.checkable) {
            return;
        }
        if (this.tree == null || this.tree.isDisposed()) {
            Logger.error((String)"unable to set checked state - no paint(Composite) called or tree disposed");
            return;
        }
        for (int i = 0; i < objects.length; ++i) {
            Item item;
            if (objects[i] == null || (item = this.itemLookup.get(objects[i])) == null) continue;
            item.item.setChecked(checked);
        }
    }

    private void add(TreeItem item, List list) {
        TreeItem[] children;
        if (item == null || item.isDisposed()) {
            return;
        }
        if (item.getChecked()) {
            list.add(item.getData());
        }
        for (TreeItem child : children = item.getItems()) {
            this.add(child, list);
        }
    }

    @Override
    public void removeAll() {
        this.list = null;
        this.itemLookup.clear();
        this.autoimage.clear();
        if (this.tree != null && !this.tree.isDisposed()) {
            this.tree.removeAll();
        }
        this.featureEvent(Feature.Event.REMOVED_ALL, null);
    }

    @Override
    public int size() {
        if (this.tree == null || this.tree.isDisposed()) {
            return this.list.size();
        }
        return this.count(this.tree.getItems());
    }

    private int count(TreeItem[] items) {
        int count = 0;
        for (TreeItem i : items) {
            ++count;
            count += this.count(i.getItems());
        }
        return count;
    }

    private class GenericTreeItemComparator
    implements Comparator<TreeItem> {
        private String columnId;
        private int columnIndex;

        public GenericTreeItemComparator(Column columnToCompare, int columnIndex) {
            this.columnId = columnToCompare.getColumnId();
            this.columnIndex = columnIndex;
        }

        @Override
        public int compare(TreeItem item1, TreeItem item2) {
            try {
                Object colData1 = BeanUtil.get((Object)item1.getData(), (String)this.columnId);
                Object colData2 = BeanUtil.get((Object)item2.getData(), (String)this.columnId);
                if (colData1 instanceof Comparable) {
                    return ((Comparable)colData1).compareTo(colData2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.getText(item1).compareTo(this.getText(item2));
        }

        private String getText(TreeItem item) {
            String result = item.getText(this.columnIndex);
            return result == null ? "" : result;
        }
    }

    class Item {
        private final TreeItem item;

        Item(TreeItem parent, Object data) throws RemoteException {
            List children;
            this.item = parent == null ? new TreeItem(TreePart.this.tree, 0) : new TreeItem(parent, 0);
            this.item.setFont(Font.DEFAULT.getSWTFont());
            this.item.setData(data);
            if (TreePart.this.columns.size() == 0) {
                String s = BeanUtil.toString((Object)data);
                this.item.setText(s != null ? s : "");
            } else {
                for (int i = 0; i < TreePart.this.columns.size(); ++i) {
                    Column c = (Column)TreePart.this.columns.get(i);
                    Object value = BeanUtil.get((Object)data, (String)c.getColumnId());
                    this.item.setText(i, c.getFormattedValue(value, data));
                }
            }
            if (TreePart.this.formatter != null) {
                TreePart.this.formatter.format(this.item);
            }
            if ((children = TreePart.this.getChildren(data)) != null) {
                if (this.item.getImage() == null) {
                    this.item.setImage(SWTUtil.getImage(TreePart.this.expanded ? IMG_FOLDER_OPEN : IMG_FOLDER_CLOSE));
                    TreePart.this.autoimage.put(this.item, Boolean.TRUE);
                }
                for (Object c : children) {
                    try {
                        Item i = new Item(this.item, c);
                        TreePart.this.itemLookup.put(c, i);
                        TreePart.this.setExpanded(c, TreePart.this.expanded);
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while expanding item", (Throwable)e);
                    }
                }
            }
            if (this.item.getImage() == null) {
                this.item.setImage(SWTUtil.getImage(IMG_DEFAULT));
            }
        }
    }
}

